/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data.coverage;

import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;

public abstract class Dataset2D {
    private long width;
    private long height;

    public static Dataset2D fromDoubles(int width, int height, double[] data) {
        return new Dataset2DDoubles(width, height, data);
    }

    public static Dataset2D combine(List<Dataset2D> datasets, Struct combinedType) {
        return new CombinedDataset2D(datasets, combinedType);
    }

    protected int getIndex(long x, long y) {
        long index = y * this.width + x;
        if (index > Integer.MAX_VALUE) {
            throw new IllegalStateException("Dataset co-ordinates too big for array index");
        }
        return (int)index;
    }

    public boolean isInBounds(long x, long y) {
        boolean xInBounds = 0L <= x && x < this.width;
        boolean yInBounds = 0L <= y && y < this.height;
        return xInBounds && yInBounds;
    }

    public abstract Object getValue(long var1, long var3);

    public abstract Type getType();

    @Generated
    public Dataset2D(long width, long height) {
        this.width = width;
        this.height = height;
    }

    @Generated
    public long getWidth() {
        return this.width;
    }

    @Generated
    public long getHeight() {
        return this.height;
    }

    static final class Dataset2DDoubles
    extends Dataset2D {
        private final double[] data;

        Dataset2DDoubles(long width, long height, double[] data) {
            super(width, height);
            this.data = data;
        }

        @Override
        public Double getValue(long x, long y) {
            int index = this.getIndex(x, y);
            return this.data[index];
        }

        @Override
        public Type getType() {
            return Types.FLOATING;
        }
    }

    static final class CombinedDataset2D
    extends Dataset2D {
        private final List<Dataset2D> datasets;
        private final Struct type;

        CombinedDataset2D(List<Dataset2D> datasets, Struct combinedType) {
            super(datasets.get(0).getWidth(), datasets.get(0).getHeight());
            this.datasets = datasets;
            this.type = combinedType;
        }

        public Tuple getValue(long x, long y) {
            Object[] values = new Object[this.datasets.size()];
            for (int i = 0; i < this.datasets.size(); ++i) {
                values[i] = this.datasets.get(i).getValue(x, y);
            }
            return Tuple.ofValues((Struct)this.type, (Object[])values);
        }

        @Generated
        public Struct getType() {
            return this.type;
        }
    }
}

