/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data.coverage;

import lombok.Generated;
import nz.org.riskscape.engine.SRIDSet;
import org.geotools.api.geometry.Position;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class CoverageValueProviderHelper {
    private final ReferencedEnvelope envelope;
    private final SRIDSet sridSet;
    private final int gridSrid;

    public CoverageValueProviderHelper(ReferencedEnvelope envelope, SRIDSet sridSet) {
        this.envelope = envelope;
        this.sridSet = sridSet;
        this.gridSrid = sridSet.get(envelope.getCoordinateReferenceSystem());
    }

    public Geometry reprojectIfNecessary(Geometry geom) throws EmptyGeometryException {
        if (geom.isEmpty()) {
            throw new EmptyGeometryException();
        }
        if (geom.getSRID() != this.gridSrid) {
            return this.sridSet.reproject(geom, this.gridSrid);
        }
        return geom;
    }

    public boolean contains(Position position) {
        return this.envelope.contains(position);
    }

    public Position pointToDirectPosition(Point point) {
        return new Position2D(this.envelope.getCoordinateReferenceSystem(), point.getX(), point.getY());
    }

    @Generated
    public ReferencedEnvelope getEnvelope() {
        return this.envelope;
    }

    public class EmptyGeometryException
    extends Exception {
    }
}

