/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data.coverage;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.FileProblems;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.data.BaseBookmarkResolver;
import nz.org.riskscape.engine.data.BookmarkParameters;
import nz.org.riskscape.engine.data.coverage.GridTypedCoverage;
import nz.org.riskscape.engine.data.coverage.MappedCoverage;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.tiff.SparseTIFFImageReaderSpi;
import nz.org.riskscape.engine.tiff.SparseTiffCoverage;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.Lambda;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.UnknownFormat;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.util.factory.Hints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoverageFileBookmarkResolver
extends BaseBookmarkResolver<Params> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CoverageFileBookmarkResolver.class);
    public static final Map<String, String> EXTENSIONS_TO_FORMATS = ImmutableMap.builder().put((Object)"asc", (Object)"arcgrid").put((Object)"tif", (Object)"geotiff").put((Object)"tiff", (Object)"geotiff").build();
    protected static final String MEMO_FILE = "file";

    public CoverageFileBookmarkResolver(Engine engine) {
        super(engine);
    }

    protected JavaParameterSet<Params> buildParameterSet() {
        Params instance = new Params();
        instance.sparseTiff = this.engine.isBetaPluginEnabled();
        return JavaParameterSet.fromBindingInstance((Class)this.getParamsClass(), (Object)((Object)instance));
    }

    protected Map<String, String> getAliasMapping() {
        return ImmutableMap.of((Object)"crs-force-xy", (Object)"crs-longitude-first");
    }

    protected Map<String, String> getExtensionsToFormats() {
        return EXTENSIONS_TO_FORMATS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultOrProblems<? extends Object> build(Params params) {
        GeoTiffReader reader = null;
        try {
            ResultOrProblems hints;
            boolean isTiff;
            File file = this.getBookmarkedPath(params).toFile();
            String fileExtension = Files.getFileExtension((String)file.getName());
            if ("tif".equals(fileExtension) || "tiff".equals(fileExtension)) {
                Hints hints2 = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
                params.crs.ifPresent(c -> hints2.put((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, c));
                if (params.sparseTiff) {
                    hints2.put((Object)GeoTiffReader.HINT_READER_SPI, (Object)new SparseTIFFImageReaderSpi());
                }
                try {
                    reader = new GeoTiffReader(file, hints2);
                }
                catch (DataSourceException ex) {
                    ResultOrProblems resultOrProblems = ResultOrProblems.failed((Problem[])new Problem[]{FileProblems.get().geotoolsCannotRead(file).withChildren(new Problems[]{Problems.caught((Throwable)ex)}), FileProblems.get().badGeospatialDataTip(file, "GeoTIFF")});
                    try {
                        if (reader != null) {
                            reader.dispose();
                        }
                    }
                    catch (IOException e) {
                        log.warn("Failed to dispose coverage reader", (Throwable)e);
                    }
                    return resultOrProblems;
                }
                isTiff = true;
            } else {
                AbstractGridFormat format = this.findFormat(params, file);
                if (format == null || format.equals((Format)new UnknownFormat())) {
                    ResultOrProblems ex = ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((String)"Could not open '%s' - check that the format matches the file extension", (Object[])new Object[]{file})});
                    return ex;
                }
                hints = this.buildHints(params);
                if (hints.hasErrors()) {
                    ResultOrProblems e = ResultOrProblems.failed((List)hints.getProblems());
                    return e;
                }
                reader = format.getReader((Object)file, (Hints)hints.get());
                isTiff = false;
            }
            List<String> availableLayers = Arrays.asList(reader.getGridCoverageNames());
            if (!params.layer.isPresent()) {
                params.layer = Optional.of(availableLayers.get(0));
            } else if (!availableLayers.contains(params.layer.get())) {
                hints = ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((String)"Layer '%s' is not a known layer. Available layers are %s", (Object[])new Object[]{params.layer.get(), availableLayers})});
                return hints;
            }
            GridCoverage2D coverage = reader.read(params.layer.get(), null);
            if (isTiff && params.sparseTiff) {
                coverage = SparseTiffCoverage.createIfSupported((GridCoverage)coverage, file);
            }
            if (!(coverage instanceof GridCoverage2D)) {
                ResultOrProblems e = ResultOrProblems.failed((Problem[])new Problem[]{GeneralProblems.get().operationNotSupported("coverage", coverage.getClass())});
                return e;
            }
            GridTypedCoverage typedCoverage = new GridTypedCoverage(coverage, params.getProject().getSridSet());
            ResultOrProblems resultOrProblems = params.mapValue.map(expr -> this.buildMappedCoverage(params.getRealizationContext(), typedCoverage, (Expression)expr).composeProblems(Problems.foundWith((Object)this.getParameterSet().get("map-value"), (Problem[])new Problem[0]))).orElse(ResultOrProblems.of((Object)typedCoverage));
            return resultOrProblems;
        }
        catch (Exception e) {
            ResultOrProblems resultOrProblems = ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((Throwable)e, (String)"Failed to open '%s' - %s", (Object[])new Object[]{params.getLocation(), e.getMessage()})}).withMoreProblems(new Problem[]{Problems.caught((Throwable)e)});
            return resultOrProblems;
        }
        finally {
            try {
                if (reader != null) {
                    reader.dispose();
                }
            }
            catch (IOException e) {
                log.warn("Failed to dispose coverage reader", (Throwable)e);
            }
        }
    }

    private ResultOrProblems<TypedCoverage> buildMappedCoverage(RealizationContext context, GridTypedCoverage coverage, Expression expression) {
        return expression.isA(Lambda.class).map(lambda -> MappedCoverage.build((RealizationContext)context, (TypedCoverage)coverage, (Lambda)lambda)).orElse(MappedCoverage.build((RealizationContext)context, (TypedCoverage)coverage, (String)"value", (Expression)expression));
    }

    protected ResultOrProblems<Hints> buildHints(Params params) {
        CoordinateReferenceSystem crs;
        Hints hints = new Hints();
        ArrayList problems = new ArrayList();
        params.crs.ifPresent(c -> hints.put((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, c));
        if (!params.crs.isPresent() && (crs = this.attemptPrjParse(params.getLocation(), problems)) != null) {
            hints.put((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, (Object)crs);
        }
        return ResultOrProblems.of((Object)hints, problems);
    }

    protected void validateParameters(Params params, BindingContext context) {
        params.crsName.ifPresent(name -> BaseBookmarkResolver.setCrs((BookmarkParameters)params, (String)name, (boolean)params.crsLongitudeFirst, (Parameter)this.getParameterSet().get("crs-name"), crs -> {
            params.crs = Optional.of(crs);
        }));
    }

    protected AbstractGridFormat findFormat(Params params, File file) {
        return GridFormatFinder.findFormat((Object)file);
    }

    public static class Params
    extends BookmarkParameters {
        @ParameterField
        public Optional<String> layer = Optional.empty();
        @ParameterField
        public Optional<String> crsName = Optional.empty();
        @ParameterField
        public boolean crsLongitudeFirst = true;
        @ParameterField
        public Optional<Expression> mapValue;
        public Optional<CoordinateReferenceSystem> crs = Optional.empty();
        @ParameterField
        public boolean sparseTiff = true;

        public Class<?> getDataType() {
            return this.mapValue.isPresent() ? MappedCoverage.class : GridTypedCoverage.class;
        }
    }
}

