/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.data.Bookmark;
import nz.org.riskscape.engine.data.BookmarkProblems;
import nz.org.riskscape.engine.data.BookmarkResolver;
import nz.org.riskscape.engine.data.BookmarkResolvers;
import nz.org.riskscape.engine.data.ResolvedBookmark;
import nz.org.riskscape.engine.output.Format;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class DefaultBookmarkResolvers
extends IdentifiedCollection.Base<BookmarkResolver>
implements BookmarkResolvers {
    public ResultOrProblems<ResolvedBookmark> resolve(Bookmark bookmark, BindingContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (bookmark.getLocation() == null) {
            return ResultOrProblems.failed((Problem[])new Problem[]{GeneralProblems.required((String)"location", Parameter.class)});
        }
        for (BookmarkResolver resolver : this.getAll()) {
            Optional resolved;
            try {
                resolved = resolver.resolve(bookmark, context);
            }
            catch (IOException e) {
                problems.add(Problem.warning((Throwable)e, (String)"I/O error with resolver %s - %s", (Object[])new Object[]{resolver, e.getMessage()}));
                continue;
            }
            if (!resolved.isPresent()) continue;
            return ResultOrProblems.of((Object)((ResolvedBookmark)resolved.get()), (List)((ResolvedBookmark)resolved.get()).validate());
        }
        if (bookmark.isFromURI()) {
            problems.add(0, BookmarkProblems.get().notBookmarkOrFile(bookmark.getId()));
        } else if (Strings.isNullOrEmpty((String)bookmark.getFormat())) {
            problems.add(0, BookmarkProblems.get().couldNotResolve(bookmark.getLocation().toString()));
        } else {
            problems.add(0, GeneralProblems.get().noSuchObjectExistsDidYouMean(bookmark.getFormat(), Format.class, this.getSupportedFormats()).withChildren(new Problems[]{BookmarkProblems.get().unknownFormatTip()}));
        }
        return ResultOrProblems.failed(problems);
    }

    public ResultOrProblems<ResolvedBookmark> resolveAndValidate(Bookmark bookmark, BindingContext context, Class<?> requiredType) {
        ResultOrProblems<ResolvedBookmark> resolvedOr = this.resolve(bookmark, context);
        if (resolvedOr.hasErrors()) {
            return resolvedOr.composeFailure(Problems.foundWith((Object)bookmark, (Problem[])new Problem[0]));
        }
        ResolvedBookmark resolved = (ResolvedBookmark)resolvedOr.getWithProblemsIgnored();
        if (resolved.hasValidationErrors()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problems.foundWith((Object)bookmark, (List)resolved.validate())});
        }
        ResultOrProblems dataOr = resolved.getData(requiredType);
        if (dataOr.hasErrors()) {
            return dataOr.composeFailure(Problems.foundWith((Object)bookmark, (Problem[])new Problem[0]));
        }
        return resolvedOr;
    }

    public <T> ResultOrProblems<T> getData(Bookmark bookmark, BindingContext context, Class<T> requiredType) {
        return this.resolveAndValidate(bookmark, context, requiredType).map(rb -> rb.getData(requiredType).get());
    }
}

