/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import nz.org.riskscape.config.ConfigSection;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.data.Bookmark;
import nz.org.riskscape.engine.ini.IdentifiedObjectBuilder;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.resource.UriHelper;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class BookmarkFactory
extends IdentifiedObjectBuilder.Base<Bookmark> {
    public static final String BOOKMARK_KEY = "bookmark";
    public static final String MAP_ATTRIBUTE_PREFIX = "map-attribute.";

    private static boolean isLocalFile(String location, URI relativeTo) {
        return !UriHelper.hasUriScheme((String)location) && UriHelper.isFile((URI)relativeTo);
    }

    public BookmarkFactory() {
        super(Bookmark.class, BOOKMARK_KEY);
    }

    public static ResultOrProblems<URI> uriFromLocation(String location, URI relativeTo) {
        String[] splitLocation = new String[]{};
        if (BookmarkFactory.isLocalFile(location, relativeTo)) {
            splitLocation = location.split(Pattern.quote("?"), 2);
            location = splitLocation[0];
        }
        ResultOrProblems uriResult = UriHelper.uriFromLocation((String)location, (URI)relativeTo);
        if (splitLocation.length == 2 && !uriResult.hasProblems()) {
            URI rejoinedUri = URI.create(((URI)uriResult.get()).toString() + "?" + splitLocation[1]);
            uriResult = ResultOrProblems.of((Object)rejoinedUri);
        }
        return uriResult;
    }

    @Override
    public ResultOrProblems<Bookmark> build(String id, ConfigSection section) {
        ArrayList problems = Lists.newArrayList();
        Consumer<List> addProblems = ps -> problems.addAll(ps);
        String description = section.getOne("description").map(or -> (String)or.ifElseReturn(value -> value, addProblems, (Object)"")).orElse("");
        String format = section.getOne("format").map(or -> (String)or.ifElseReturn(v -> v, addProblems, null)).orElse(null);
        String location = (String)section.getOneRequired("location").ifElseReturn(l -> l, addProblems, null);
        if (Strings.isNullOrEmpty((String)id)) {
            problems.add(GeneralProblems.required((String)"id", Parameter.class));
        }
        URI uri = null;
        if (location != null) {
            ResultOrProblems<URI> uriResult = BookmarkFactory.uriFromLocation(location, section.getLocation());
            if (uriResult.hasProblems()) {
                problems.add(Problems.foundWith(Parameter.class, (String)"location", (List)uriResult.getProblems()));
            } else {
                uri = (URI)uriResult.get();
            }
        }
        if (uri == null || Problem.hasErrors((Collection)problems)) {
            return ResultOrProblems.failed((List)problems);
        }
        return ResultOrProblems.of((Object)new Bookmark(id, description, format, uri, section.toMultiMap()), (List)problems);
    }
}

