/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.core;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.config.ConfigSection;
import nz.org.riskscape.config.ini.IniConfig;
import nz.org.riskscape.engine.BuildInfo;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.auth.HttpHeaderSecret;
import nz.org.riskscape.engine.auth.SecretBuilders;
import nz.org.riskscape.engine.auth.SecretProblems;
import nz.org.riskscape.engine.auth.Secrets;
import nz.org.riskscape.engine.i18n.HasMessages;
import nz.org.riskscape.engine.i18n.ObjectRenderer;
import nz.org.riskscape.engine.ini.IniFileSecretBuilder;
import nz.org.riskscape.engine.jai.TileCacheBootstrapper;
import nz.org.riskscape.engine.plugin.BuiltInPluginDescriptor;
import nz.org.riskscape.engine.plugin.Plugin;
import nz.org.riskscape.engine.plugin.PluginDescriptor;
import nz.org.riskscape.engine.plugin.PluginFeature;
import nz.org.riskscape.engine.spi.CliCommand;
import nz.org.riskscape.engine.spi.EngineBootstrapper;
import nz.org.riskscape.engine.spi.EngineCollection;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;

public class EnginePlugin
extends Plugin {
    public static final PluginDescriptor DESCRIPTOR = new BuiltInPluginDescriptor("engine", BuildInfo.getBuildInfo(), EnginePlugin.class, null);
    public static final EnumSet<PosixFilePermission> USER_PERMISSIONS = EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
    private final List<Class<? extends PluginFeature>> extensionPoints = Arrays.asList(CliCommand.class, HasMessages.class, EngineBootstrapper.class, EngineCollection.class, ObjectRenderer.class);
    private final List<PluginFeature> features = Arrays.asList(new EngineBootstrapper("register-engine-collections", engine -> engine.getFeaturesOfType(EngineCollection.class).forEach(ec -> engine.registerCollection((IdentifiedCollection)ec.newInstance()))), EngineCollection.of(Secrets.class), EngineCollection.of(SecretBuilders.class), new EngineBootstrapper("load-user-secrets", engine -> this.loadUserSecrets((Engine)engine)), TileCacheBootstrapper.INSTANCE);

    public EnginePlugin(PluginDescriptor pDescriptor) {
        super(pDescriptor);
    }

    public List<Problem> initializeEngine(Engine engine) {
        ((SecretBuilders)engine.getCollection(SecretBuilders.class)).add((Identified)HttpHeaderSecret.BUILDER);
        return Collections.emptyList();
    }

    private void loadUserSecrets(Engine engine) {
        Path secretsPath = Secrets.getUserHomeSecrets((Engine)engine);
        if (Files.isReadable(secretsPath)) {
            ArrayList<Problem> problems = new ArrayList<Problem>();
            try {
                List<PosixFilePermission> excessPermissions = Files.getPosixFilePermissions(secretsPath, new LinkOption[0]).stream().filter(perm -> !USER_PERMISSIONS.contains(perm)).toList();
                if (!excessPermissions.isEmpty()) {
                    problems.add(SecretProblems.get().insecure(secretsPath, excessPermissions));
                }
            }
            catch (Throwable excessPermissions) {
                // empty catch block
            }
            IniConfig secrets = (IniConfig)IniConfig.load(secretsPath.toUri(), engine.getResourceFactory()).addProblemsTo(problems).orElse(null);
            if (secrets != null) {
                IniFileSecretBuilder secretBuilder = new IniFileSecretBuilder(engine);
                for (ConfigSection secret : secrets.getAll()) {
                    secretBuilder.addSecret(secret.getName(), secret);
                }
            }
            if (!problems.isEmpty()) {
                engine.getProblemSink().accept(Problems.foundWith((Object)secretsPath, problems));
            }
        }
    }

    @Generated
    public List<Class<? extends PluginFeature>> getExtensionPoints() {
        return this.extensionPoints;
    }

    @Generated
    public List<PluginFeature> getFeatures() {
        return this.features;
    }
}

