/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind.impl;

import java.net.URI;
import nz.org.riskscape.engine.FileProblems;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.ParameterBindingException;
import nz.org.riskscape.engine.bind.TypeSafeBinder;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class UriBinder
extends TypeSafeBinder<String, URI> {
    public UriBinder() {
        super(String.class, URI.class);
    }

    private static String replacePathSeparators(String path) {
        return path.replace("\\", "/");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultOrProblems<URI> bindTypedValue(BindingContext context, String value) throws ParameterBindingException {
        try {
            Object adjustedValue;
            boolean contextIsRelativeToAFile = "file".equals(context.getRelativeTo().getScheme());
            boolean hasWindowsPathSeparators = value.contains("\\");
            boolean mightBeAWindowsPathWithDriveSpecifier = value.matches("^[a-zA-Z]:.+");
            if (hasWindowsPathSeparators) {
                if (mightBeAWindowsPathWithDriveSpecifier) {
                    adjustedValue = "file:///" + UriBinder.replacePathSeparators(value);
                } else {
                    if (!contextIsRelativeToAFile) return ResultOrProblems.failed((Problem[])new Problem[]{FileProblems.get().backslashesNotAllowedInUris(value)});
                    adjustedValue = UriBinder.replacePathSeparators(value);
                }
            } else {
                adjustedValue = value;
            }
            if (!((String)adjustedValue).contains(" ")) return ResultOrProblems.of((Object)context.getRelativeTo().resolve((String)adjustedValue));
            adjustedValue = ((String)adjustedValue).replaceAll(" ", "%20");
            return ResultOrProblems.of((Object)context.getRelativeTo().resolve((String)adjustedValue));
        }
        catch (IllegalArgumentException e) {
            return ResultOrProblems.failed((Problem[])new Problem[]{FileProblems.get().badUri(value, e.getMessage()).withChildren(new Problems[]{Problems.caught((Throwable)e)})});
        }
    }
}

