/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind.impl;

import nz.org.riskscape.engine.FailedObjectException;
import nz.org.riskscape.engine.NoSuchObjectException;
import nz.org.riskscape.engine.bind.BaseBinder;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.typeset.IdentifiedType;
import nz.org.riskscape.engine.typeset.MissingTypeException;
import nz.org.riskscape.engine.typexp.TypeBuildingException;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.ExpressionProblems;

public class TypeBinder
extends BaseBinder {
    public <T> ResultOrProblems<T> bindValue(BindingContext context, Object value, Class<T> destinationType) {
        Type foundType;
        try {
            foundType = (Type)context.getProject().getTypeSet().get(TokenTypes.stripQuotes((String)value.toString()), context.getEngine().getProblemSink());
        }
        catch (FailedObjectException ex) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ex.getProblem()});
        }
        catch (NoSuchObjectException noSuchEx) {
            try {
                foundType = context.getProject().getTypeBuilder().build(value.toString());
            }
            catch (TypeBuildingException typeEx) {
                return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)noSuchEx).withChildren(new Problems[]{ExpressionProblems.get().notAValid(Type.class, value.toString()).withChildren(new Problems[]{Problems.caught((Throwable)typeEx)})})});
            }
        }
        try {
            Object requiredType;
            if (foundType instanceof IdentifiedType) {
                IdentifiedType it = (IdentifiedType)foundType;
                it.getUnderlyingType();
            }
            if ((requiredType = foundType.find(destinationType).orElse(null)) == null) {
                if (foundType instanceof IdentifiedType) {
                    IdentifiedType it = (IdentifiedType)foundType;
                    return ResultOrProblems.failed((Problem[])new Problem[]{TypeProblems.get().mismatch(value, destinationType, it.getUnderlyingType().getClass())});
                }
                return ResultOrProblems.failed((Problem[])new Problem[]{TypeProblems.get().mismatch(value, destinationType, foundType.getClass())});
            }
            return ResultOrProblems.of(requiredType);
        }
        catch (MissingTypeException typeEx) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)typeEx).withChildren(new Problems[]{ExpressionProblems.get().notAValid(Type.class, value.toString()).withChildren(new Problems[]{Problems.caught((Throwable)typeEx)})})});
        }
    }

    public boolean canBind(Class<?> sourceType, Class<?> destinationType) {
        return Type.class.isAssignableFrom(destinationType);
    }
}

