/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind.impl;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.CompatBinder;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.bind.ParameterBindingException;
import nz.org.riskscape.engine.sort.SortBy;
import nz.org.riskscape.rl.ast.Expression;

public class SortByBinder
extends CompatBinder {
    private static final Pattern NOT_A_COMPILER = Pattern.compile("^([^\\s]+)(?:\\s+(.+))?$");
    public static final SortBy.Direction DEFAULT_DIRECTION = SortBy.Direction.ASC;

    public boolean canBind(Parameter modelParameter) {
        return SortBy.class.isAssignableFrom(modelParameter.getType());
    }

    public Object bind(BindingContext context, Parameter parameter, String sortByExpression) {
        Matcher m = NOT_A_COMPILER.matcher(sortByExpression = sortByExpression.trim());
        if (m.find()) {
            String expressionString = m.group(1);
            Expression expression = this.parseExpression(context, parameter, expressionString);
            SortBy.Direction direction = this.parseDirection(parameter, m.group(2));
            return new SortBy(expression, direction);
        }
        throw new ParameterBindingException(parameter, "Could not parse sorting expression '%s'", new Object[]{sortByExpression});
    }

    private Expression parseExpression(BindingContext context, Parameter parameter, String toParse) {
        return (Expression)context.bind((Object)toParse, Expression.class).orElseThrow(probs -> new ParameterBindingException(parameter, probs));
    }

    private SortBy.Direction parseDirection(Parameter parameter, String toParse) {
        if (toParse == null) {
            return DEFAULT_DIRECTION;
        }
        try {
            return SortBy.Direction.valueOf((String)toParse.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new ParameterBindingException(parameter, "Bad direction '%s', should be one of %s", new Object[]{toParse, Arrays.asList(SortBy.Direction.values())});
        }
    }
}

