/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nz.org.riskscape.engine.bind.BaseBinder;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class NumberBinder
extends BaseBinder {
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    public static final List<Class> SUPPORTED_NUMBER_TYPES = Arrays.asList(Integer.class, Long.class, Float.class, Double.class, BigDecimal.class);

    public boolean canBind(Class<?> sourceType, Class<?> destinationType) {
        return SUPPORTED_NUMBER_TYPES.contains(destinationType) && (sourceType.equals(String.class) || Number.class.isAssignableFrom(sourceType));
    }

    public <T> ResultOrProblems<T> bindValue(BindingContext context, Object valueObj, Class<T> destinationType) {
        return this.bindValue(valueObj, destinationType);
    }

    public <T> ResultOrProblems<T> bindValue(Object valueObj, Class<T> destinationType) {
        if (valueObj instanceof String) {
            String value = valueObj.toString();
            try {
                Constructor<T> constructor = destinationType.getConstructor(String.class);
                T result = constructor.newInstance(value);
                return ResultOrProblems.of(destinationType.cast(result));
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                if (e instanceof InvocationTargetException && e.getCause() instanceof NumberFormatException) {
                    return ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.numberFormatException(value, destinationType)});
                }
                throw new RuntimeException("Reflection operation failed unexpectedly", e);
            }
        }
        Number numberValue = (Number)valueObj;
        Number result = destinationType.equals(Integer.class) ? (Number)numberValue.intValue() : (Number)(destinationType.equals(Long.class) ? (Number)numberValue.longValue() : (Number)(destinationType.equals(Float.class) ? (Number)Float.valueOf(numberValue.floatValue()) : (Number)(destinationType.equals(Double.class) ? Double.valueOf(numberValue.doubleValue()) : new BigDecimal(numberValue.toString()))));
        ArrayList<Problem> warnings = new ArrayList<Problem>();
        if (!this.areEquivalent(numberValue, result)) {
            warnings.add(GeneralProblems.get().precisionLoss(numberValue, result));
        }
        return ResultOrProblems.of(destinationType.cast(result), warnings);
    }

    private boolean areEquivalent(Number n1, Number n2) {
        BigDecimal d2;
        BigDecimal d1 = new BigDecimal(n1.toString());
        return d1.compareTo(d2 = new BigDecimal(n2.toString())) == 0;
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem numberFormatException(String var1, Class<?> var2);
    }
}

