/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.TypeSafeBinder;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import org.locationtech.jts.geom.Envelope;

public class EnvelopeBinder
extends TypeSafeBinder<String, Envelope> {
    public EnvelopeBinder() {
        super(String.class, Envelope.class);
    }

    protected ResultOrProblems<Envelope> bindTypedValue(BindingContext context, String value) {
        String[] rawBounds = value.split(",");
        ArrayList<Double> parsed = new ArrayList<Double>(rawBounds.length);
        LinkedList<Problem> problems = new LinkedList<Problem>();
        for (int i = 0; i < rawBounds.length; ++i) {
            String ordinateString = rawBounds[i].trim();
            try {
                double ordinateValue = Double.parseDouble(ordinateString);
                parsed.add(ordinateValue);
                continue;
            }
            catch (NumberFormatException ex) {
                problems.add(Problem.error((String)"%s", (Object[])new Object[]{String.format("Ordinate %d (%s) is not a number - %s", i + 1, ordinateString, ex.getMessage())}));
            }
        }
        if (rawBounds.length != Ordinates.values().length) {
            problems.add(Problem.error((String)"%s", (Object[])new Object[]{String.format("A bounding box must consist of exactly 4 numbers - (%s) - was %d", Arrays.asList(Ordinates.values()), rawBounds.length)}));
        }
        if (problems.isEmpty()) {
            return ResultOrProblems.of((Object)new Envelope(((Double)parsed.get(Ordinates.MIN_X.ordinal())).doubleValue(), ((Double)parsed.get(Ordinates.MAX_X.ordinal())).doubleValue(), ((Double)parsed.get(Ordinates.MIN_Y.ordinal())).doubleValue(), ((Double)parsed.get(Ordinates.MAX_Y.ordinal())).doubleValue()));
        }
        return ResultOrProblems.failed(problems);
    }

    static enum Ordinates {
        MIN_X,
        MAX_X,
        MIN_Y,
        MAX_Y;

    }
}

