/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind.impl;

import java.util.Arrays;
import nz.org.riskscape.engine.bind.BaseBinder;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;

public class EnumBinder
extends BaseBinder {
    public boolean canBind(Class<?> sourceType, Class<?> destinationType) {
        return destinationType.isEnum();
    }

    public <T> ResultOrProblems<T> bindValue(BindingContext context, Object objValue, Class<T> destinationType) {
        Enum[] values;
        String value = objValue.toString();
        Class<T> enumClass = destinationType;
        for (Enum enumValue : values = (Enum[])enumClass.getEnumConstants()) {
            if (!enumValue.toString().equalsIgnoreCase(value)) continue;
            return ResultOrProblems.of(destinationType.cast(enumValue));
        }
        return ResultOrProblems.failed((Problem[])new Problem[]{GeneralProblems.get().notAnOption(value, destinationType, Arrays.asList(values))});
    }
}

