/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind.impl;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.TypeSafeBinder;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;

public class BooleanBinder
extends TypeSafeBinder<Object, Boolean> {
    public static final List<String> TRUE_OPTIONS = Arrays.asList("yes", "y", "t", "true", "1");
    public static final List<String> FALSE_OPTIONS = Arrays.asList("no", "n", "false", "f", "0");
    private static final List<?> ALL_OPTIONS = ImmutableList.builder().addAll(TRUE_OPTIONS).addAll(FALSE_OPTIONS).build();

    public BooleanBinder() {
        super(Object.class, Boolean.class);
    }

    protected ResultOrProblems<Boolean> bindTypedValue(BindingContext context, Object objValue) {
        return this.bindValue(objValue);
    }

    public ResultOrProblems<Boolean> bindValue(Object objValue) {
        String value = objValue.toString().toLowerCase();
        if (TRUE_OPTIONS.contains(value)) {
            return ResultOrProblems.of((Object)true);
        }
        if (FALSE_OPTIONS.contains(value)) {
            return ResultOrProblems.of((Object)false);
        }
        return ResultOrProblems.failed((Problem[])new Problem[]{GeneralProblems.get().notAnOption(value, Boolean.class, ALL_OPTIONS)});
    }
}

