/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind.impl;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import nz.org.riskscape.engine.bind.BaseBinder;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.data.Bookmark;
import nz.org.riskscape.engine.data.BookmarkFactory;
import nz.org.riskscape.engine.data.BookmarkProblems;
import nz.org.riskscape.engine.data.ResolvedBookmark;
import nz.org.riskscape.engine.data.coverage.GridTypedCoverage;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.problem.SeverityLevel;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.WithMetadata;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.TokenTypes;
import org.geotools.api.coverage.grid.GridCoverage;

public class BookmarkBinder
extends BaseBinder {
    public static final Set<Class<?>> SUPPORTED_TYPES = ImmutableSet.of(Relation.class, GridCoverage.class, GridTypedCoverage.class, ResolvedBookmark.class);
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);

    public boolean canBind(Class<?> sourceType, Class<?> destinationType) {
        return sourceType.equals(String.class) && SUPPORTED_TYPES.contains(destinationType);
    }

    public <T> ResultOrProblems<T> bindValue(BindingContext context, Object obj, Class<T> destinationType) {
        Class requiredType;
        boolean keepWrapped;
        String value = TokenTypes.stripQuotes((String)obj.toString());
        ResultOrProblems lookupResult = this.wrapLookupNullOnMissing(context, Bookmark.class, value);
        if (lookupResult != null && lookupResult.hasErrors()) {
            return ResultOrProblems.failed((List)lookupResult.getProblems());
        }
        Bookmark bookmark = lookupResult == null ? (Bookmark)this.getBookmarkFromExpression(context, value).orElse(null) : (Bookmark)lookupResult.get();
        if (bookmark == null) {
            URI tryThis = (URI)BookmarkFactory.uriFromLocation(value, context.getRelativeTo()).orElse(null);
            if (tryThis == null) {
                return ResultOrProblems.failed((Problem[])new Problem[]{BookmarkProblems.get().notBookmarkOrFile(value)});
            }
            bookmark = Bookmark.fromURI((URI)tryThis, (String)value);
        }
        if (ResolvedBookmark.class.isAssignableFrom(destinationType)) {
            keepWrapped = true;
            requiredType = Object.class;
        } else {
            keepWrapped = false;
            requiredType = destinationType;
        }
        ResultOrProblems resolvedOr = context.getEngine().getBookmarkResolvers().resolveAndValidate(bookmark, context, Object.class);
        if (keepWrapped) {
            ArrayList problems = new ArrayList();
            resolvedOr.ifPresent(rb -> problems.addAll(rb.getData(rb.getDataType()).getProblems()));
            return resolvedOr.map(rb -> destinationType.cast(rb)).withMoreProblems(problems);
        }
        LinkedList<Problem> extraProblems = new LinkedList<Problem>();
        TypedCoverage coverage = (TypedCoverage)resolvedOr.flatMap(rb -> rb.getData(TypedCoverage.class)).orElse(null);
        if (requiredType.equals(Relation.class) && coverage != null) {
            Relation relation = coverage.asRelation().orElse(null);
            if (relation != null) {
                return ResultOrProblems.of(destinationType.cast(relation));
            }
            extraProblems.add(PROBLEMS.couldNotConvert());
        }
        return resolvedOr.flatMap(rb -> rb.getData(destinationType).withMoreProblems((Collection)extraProblems));
    }

    private Optional<Bookmark> getBookmarkFromExpression(BindingContext context, String value) {
        return (Optional)context.getRealizationContext().realizeConstant(value).map(realized -> WithMetadata.find((Type)realized.getResultType(), Bookmark.class)).orElse(Optional.empty());
    }

    static interface LocalProblems
    extends ProblemFactory {
        @SeverityLevel(value=Problem.Severity.WARNING)
        public Problem couldNotConvert();
    }
}

