/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind.impl;

import java.util.ArrayList;
import nz.org.riskscape.dsl.Lexer;
import nz.org.riskscape.dsl.LexerException;
import nz.org.riskscape.dsl.ParseException;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.dsl.TokenType;
import nz.org.riskscape.engine.bind.BaseBinder;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.impl.TypeBinder;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.typeset.IdentifiedType;
import nz.org.riskscape.engine.typeset.MissingTypeException;
import nz.org.riskscape.engine.typexp.AST;
import nz.org.riskscape.engine.typexp.Parser;
import nz.org.riskscape.engine.typexp.TypeBuildingException;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.ExpressionProblems;

public class ArgumentListBinder
extends BaseBinder {
    private final TypeBinder typeBinder = new TypeBinder();

    public <T> ResultOrProblems<T> bindValue(BindingContext context, Object value, Class<T> destinationType) {
        return ProblemException.catching(() -> destinationType.cast(this.parseArgumentList(context, value.toString())));
    }

    private ArgumentList parseArgumentList(BindingContext context, String source) throws ProblemException {
        Lexer lexer = new Lexer(TokenTypes.tokens(), source);
        ArrayList<FunctionArgument> args = new ArrayList<FunctionArgument>();
        String exprToParse = source;
        try {
            lexer.expect(new TokenType[]{TokenTypes.LBRACK});
            exprToParse = this.remainingText((Lexer<TokenTypes>)lexer);
            while (lexer.peekType() != TokenTypes.RBRACK) {
                String keyword = this.consumeKeyword((Lexer<TokenTypes>)lexer);
                Type type = this.parseType(context, (Lexer<TokenTypes>)lexer);
                if (keyword == null) {
                    args.add(new FunctionArgument(-1, type));
                } else {
                    args.add(new FunctionArgument(keyword, type));
                }
                if (lexer.peekType() != TokenTypes.RBRACK) {
                    lexer.expect(new TokenType[]{TokenTypes.COMMA});
                }
                exprToParse = this.remainingText((Lexer<TokenTypes>)lexer);
            }
        }
        catch (LexerException | ParseException e) {
            throw new ProblemException((Problems)ExpressionProblems.get().notAValid(Type.class, exprToParse).withChildren(new Problems[]{Problems.caught((Throwable)e)}));
        }
        return new ArgumentList(args);
    }

    private String consumeKeyword(Lexer<TokenTypes> lexer) {
        Token possibleKeyword = lexer.consumeIf((TokenType)TokenTypes.KEY_IDENTIFIER).orElse(null);
        if (possibleKeyword != null) {
            lexer.next();
            return possibleKeyword.getValue();
        }
        return null;
    }

    private Type parseType(BindingContext context, Lexer<TokenTypes> lexer) throws ProblemException {
        Parser parser = new Parser(lexer);
        String exprToParse = this.remainingText(lexer);
        AST parsed = null;
        try {
            parsed = parser.parseType();
        }
        catch (LexerException | ParseException e) {
            throw new ProblemException((Problems)ExpressionProblems.get().notAValid(Type.class, exprToParse).withChildren(new Problems[]{Problems.caught((Throwable)e)}));
        }
        if (parsed instanceof AST.ComplexType) {
            try {
                Type built = context.getProject().getTypeBuilder().buildComplexType((AST.ComplexType)parsed);
                if (built instanceof IdentifiedType) {
                    IdentifiedType it = (IdentifiedType)built;
                    it.getUnderlyingType();
                }
                return built;
            }
            catch (MissingTypeException | TypeBuildingException ex) {
                throw new ProblemException((Problems)ExpressionProblems.get().notAValid(Type.class, exprToParse).withChildren(new Problems[]{Problems.caught((Throwable)ex)}));
            }
        }
        return (Type)this.typeBinder.bindValue(context, parsed.value.getValue(), Type.class).getOrThrow();
    }

    private String remainingText(Lexer<TokenTypes> lexer) {
        return lexer.remaining().replaceAll("\\]$", "").trim();
    }

    public boolean canBind(Class<?> sourceType, Class<?> destinationType) {
        return ArgumentList.class.isAssignableFrom(destinationType);
    }
}

