/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.bind.ParameterProperty;
import nz.org.riskscape.engine.data.ResolvedBookmark;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ListDeclaration;

public enum TypedProperty implements ParameterProperty
{
    NUMERIC(Double.class, new ParameterProperty[0]),
    INTEGER(Long.class, NUMERIC),
    TEXT(String.class, new ParameterProperty[0]),
    LIST(ListDeclaration.class, new ParameterProperty[0]),
    BOOKMARK(ResolvedBookmark.class, new ParameterProperty[0]),
    FILE(String.class, TEXT),
    EXPRESSION(Expression.class, new ParameterProperty[0]);

    private static final List<TypedProperty> PRECEDENCE;
    private final Class<?> parameterType;
    private final List<ParameterProperty> implied;

    public static Optional<TypedProperty> findBest(Collection<ParameterProperty> properties) {
        List filtered = ParameterProperty.filter(properties, TypedProperty.class);
        for (TypedProperty prop : PRECEDENCE) {
            if (!filtered.contains((Object)prop)) continue;
            return Optional.of(prop);
        }
        return filtered.stream().findFirst();
    }

    private TypedProperty(Class<?> parameterType, ParameterProperty ... implied) {
        this(parameterType, Arrays.asList(implied));
    }

    public boolean isCompatible(ParameterProperty that) {
        boolean isImplied = this.implies(that) || that.implies((ParameterProperty)this);
        boolean isAList = this.equals((Object)LIST) || that.equals((Object)LIST);
        boolean related = isImplied || isAList || this.equals(that);
        return related || !(that instanceof TypedProperty);
    }

    public String getKeyword() {
        return this.name().toLowerCase();
    }

    @Generated
    private TypedProperty(Class<?> parameterType, List<ParameterProperty> implied) {
        this.parameterType = parameterType;
        this.implied = implied;
    }

    @Generated
    public Class<?> getParameterType() {
        return this.parameterType;
    }

    @Generated
    public List<ParameterProperty> getImplied() {
        return this.implied;
    }

    static {
        PRECEDENCE = Arrays.asList(EXPRESSION, LIST, INTEGER);
    }
}

