/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind;

import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.InputFieldProperty;
import nz.org.riskscape.engine.bind.KeyValueProperty;
import nz.org.riskscape.engine.bind.ParamProblems;
import nz.org.riskscape.engine.bind.ParameterProperty;
import nz.org.riskscape.engine.bind.TypedProperty;
import nz.org.riskscape.engine.data.ResolvedBookmark;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Value;
import nz.org.riskscape.engine.typeset.IdentifiedType;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Constant;
import nz.org.riskscape.rl.ast.ListDeclaration;
import nz.org.riskscape.util.ListUtils;

public class ParameterProperties {
    public static final KeyValueProperty<Double> MIN_VALUE = KeyValueProperty.numeric("min", Double.MIN_VALUE).withValidation((prop, bound) -> {
        if (((Number)bound).doubleValue() < (Double)prop.getValue()) {
            return Arrays.asList(GeneralProblems.get().badValue(bound, prop, (Object)(">= " + String.valueOf(prop.getValue()))));
        }
        return Collections.emptyList();
    });
    public static final KeyValueProperty<Double> MAX_VALUE = KeyValueProperty.numeric("max", Double.MAX_VALUE).withValidation((prop, bound) -> {
        if (((Number)bound).doubleValue() > (Double)prop.getValue()) {
            return Arrays.asList(GeneralProblems.get().badValue(bound, prop, (Object)("<= " + String.valueOf(prop.getValue()))));
        }
        return Collections.emptyList();
    });
    public static final KeyValueProperty<Double> STEP_INCREMENT = KeyValueProperty.numeric("step", 1.0);
    public static final KeyValueProperty<String> BOOKMARK_TEMPLATE = new KeyValueProperty<String>("bookmark-template", "").withImplied(TypedProperty.BOOKMARK).withCompatibility(prop -> TypedProperty.BOOKMARK.isCompatible((ParameterProperty)prop) && ParameterProperties.checkCompatible(TypedProperty.BOOKMARK, prop.getImplied()).isEmpty()).withValueBinding((context, val) -> context.bind(val, ResolvedBookmark.class).map(bookmark -> val.toString()));
    public static final KeyValueProperty<IdentifiedType> TYPE = new KeyValueProperty<Class<IdentifiedType>>("type", IdentifiedType.class).withImplied(TypedProperty.BOOKMARK).withCompatibility(otherProp -> TypedProperty.BOOKMARK.isCompatible((ParameterProperty)otherProp) && ParameterProperties.checkCompatible(TypedProperty.BOOKMARK, otherProp.getImplied()).isEmpty());
    public static final List<KeyValueProperty<?>> KEY_VALUE_PROPERTIES = Arrays.asList(MIN_VALUE, MAX_VALUE, STEP_INCREMENT, BOOKMARK_TEMPLATE, TYPE);
    public static final List<ParameterProperty> ALL_PROPERTIES = ListUtils.concat((List)ListUtils.concat(Arrays.asList(TypedProperty.values()), Arrays.asList(InputFieldProperty.values())), KEY_VALUE_PROPERTIES);
    public static final List<String> AVAILABLE_KEYWORDS = Lists.transform(ALL_PROPERTIES, p -> p.getKeyword());

    public static Optional<ParameterProperty> find(String keyword) {
        return ALL_PROPERTIES.stream().filter(p -> p.getKeyword().equals(keyword)).findFirst();
    }

    public static List<Problem> checkCompatible(ParameterProperty newProperty, Collection<ParameterProperty> existingProperties) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        for (ParameterProperty existing : existingProperties) {
            if (existing.equals(newProperty) || newProperty.isCompatible(existing) && existing.isCompatible(newProperty)) continue;
            problems.add(ParamProblems.get().mutuallyExclusive(newProperty.getKeyword(), existing.getKeyword()));
        }
        return problems;
    }

    public static ResultOrProblems<ParameterProperty> build(BindingContext context, String keyword, Optional<?> rawValue) {
        ParameterProperty property = ParameterProperties.find(keyword).orElse(null);
        if (property == null) {
            return ResultOrProblems.failed((Problem[])new Problem[]{GeneralProblems.get().notAnOption(keyword, ParameterProperty.class, AVAILABLE_KEYWORDS)});
        }
        if (property.hasKeyValuePair() != rawValue.isPresent()) {
            Range expected = property.hasKeyValuePair() ? Range.singleton((Comparable)Integer.valueOf(1)) : Range.singleton((Comparable)Integer.valueOf(0));
            return ResultOrProblems.failed((Problem[])new Problem[]{GeneralProblems.get().badArity(Value.class, (Object)property, expected, rawValue.isPresent() ? 1 : 0)});
        }
        if (property.hasKeyValuePair()) {
            return property.withValue(context, rawValue.get());
        }
        return ResultOrProblems.of((Object)property);
    }

    public static Set<ParameterProperty> infer(Object defaultValue) {
        if (defaultValue instanceof RealizedExpression) {
            return ParameterProperties.infer((RealizedExpression)defaultValue);
        }
        return Collections.emptySet();
    }

    public static Set<ParameterProperty> infer(RealizedExpression defaultValue) {
        HashSet<ParameterProperty> properties = new HashSet<ParameterProperty>();
        if (defaultValue.getExpression() instanceof Constant || defaultValue.getExpression() instanceof ListDeclaration) {
            Type result = defaultValue.getResultType();
            if (result.isA(RSList.class)) {
                properties.add(InputFieldProperty.MULTISELECT);
                result = result.findAllowNull(RSList.class).map(list -> list.getMemberType()).orElse(result);
            }
            if (result.isNumeric()) {
                properties.add(TypedProperty.NUMERIC);
            }
        }
        return properties;
    }

    public static Set<ParameterProperty> infer(Class<?> expectedClass) {
        HashSet<ParameterProperty> properties = new HashSet<ParameterProperty>();
        if (expectedClass == ResolvedBookmark.class) {
            properties.add(TypedProperty.BOOKMARK);
        }
        return properties;
    }

    public static Optional<Class<?>> getBindingClass(Collection<ParameterProperty> properties) {
        return TypedProperty.findBest(properties).map(p -> p.getParameterType());
    }

    @Generated
    public ParameterProperties() {
    }
}

