/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.ParameterProperty;
import nz.org.riskscape.engine.bind.TypedProperty;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class KeyValueProperty<T>
implements ParameterProperty {
    private final String keyword;
    private final T value;
    private final List<ParameterProperty> implied;
    private final Function<ParameterProperty, Boolean> checkCompatible;
    private final BiFunction<KeyValueProperty<T>, Object, List<Problem>> checkValid;
    private final BiFunction<BindingContext, Object, ResultOrProblems<T>> valueBinder;

    public static KeyValueProperty<Double> numeric(String name, double placeholder) {
        return new KeyValueProperty<Double>(name, placeholder).withImplied(TypedProperty.NUMERIC).withCompatibility(prop -> TypedProperty.NUMERIC.isCompatible((ParameterProperty)prop));
    }

    public KeyValueProperty(String key, Class<T> bindType) {
        this(key, null, Collections.emptyList(), p -> true, (c, v) -> Collections.emptyList(), (c, v) -> c.bind(v, bindType));
    }

    public KeyValueProperty(String key, @NonNull T value) {
        this(key, value, Collections.emptyList(), p -> true, (c, v) -> Collections.emptyList(), (c, v) -> c.bind(v, value.getClass()));
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
    }

    public boolean isCompatible(ParameterProperty other) {
        return this.checkCompatible.apply(other);
    }

    public Optional<?> getValueOr() {
        return Optional.ofNullable(this.value);
    }

    public List<Problem> validate(BindingContext context, Object bound) {
        return this.checkValid.apply(this, bound);
    }

    public ParameterProperty withValue(Object newValue) {
        return new KeyValueProperty<Object>(this.keyword, newValue, this.implied, this.checkCompatible, this.checkValid, this.valueBinder);
    }

    public ResultOrProblems<ParameterProperty> withValue(BindingContext context, Object newValue) {
        return this.valueBinder.apply(context, newValue).map(bound -> this.withValue(bound)).composeProblems(Problems.foundWith((Object)this, (Problem[])new Problem[0]));
    }

    public KeyValueProperty<T> withImplied(ParameterProperty ... newImplied) {
        return new KeyValueProperty<T>(this.keyword, this.value, Arrays.asList(newImplied), this.checkCompatible, this.checkValid, this.valueBinder);
    }

    public KeyValueProperty<T> withCompatibility(Function<ParameterProperty, Boolean> isCompatible) {
        return new KeyValueProperty<T>(this.keyword, this.value, this.implied, isCompatible, this.checkValid, this.valueBinder);
    }

    public KeyValueProperty<T> withValidation(BiFunction<KeyValueProperty<T>, Object, List<Problem>> newValidation) {
        return new KeyValueProperty<T>(this.keyword, this.value, this.implied, this.checkCompatible, newValidation, this.valueBinder);
    }

    public KeyValueProperty<T> withValueBinding(BiFunction<BindingContext, Object, ResultOrProblems<T>> newBindValue) {
        return new KeyValueProperty<T>(this.keyword, this.value, this.implied, this.checkCompatible, this.checkValid, newBindValue);
    }

    public String toString() {
        return this.keyword.toUpperCase() + ": " + this.value.toString();
    }

    public boolean hasKeyValuePair() {
        return true;
    }

    @Generated
    public KeyValueProperty(String keyword, T value, List<ParameterProperty> implied, Function<ParameterProperty, Boolean> checkCompatible, BiFunction<KeyValueProperty<T>, Object, List<Problem>> checkValid, BiFunction<BindingContext, Object, ResultOrProblems<T>> valueBinder) {
        this.keyword = keyword;
        this.value = value;
        this.implied = implied;
        this.checkCompatible = checkCompatible;
        this.checkValid = checkValid;
        this.valueBinder = valueBinder;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyValueProperty)) {
            return false;
        }
        KeyValueProperty other = (KeyValueProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$keyword = this.getKeyword();
        String other$keyword = other.getKeyword();
        return !(this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeyValueProperty;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        return result;
    }

    @Generated
    public String getKeyword() {
        return this.keyword;
    }

    @Generated
    public T getValue() {
        return this.value;
    }

    @Generated
    public List<ParameterProperty> getImplied() {
        return this.implied;
    }

    @Generated
    public Function<ParameterProperty, Boolean> getCheckCompatible() {
        return this.checkCompatible;
    }

    @Generated
    public BiFunction<KeyValueProperty<T>, Object, List<Problem>> getCheckValid() {
        return this.checkValid;
    }
}

