/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.config.ConfigString;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.InvalidBoundParametersException;
import nz.org.riskscape.engine.bind.NoBindingAvailableException;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.bind.ParameterBinder;
import nz.org.riskscape.engine.bind.UnbindableParameterException;
import nz.org.riskscape.engine.bind.impl.ArgumentListBinder;
import nz.org.riskscape.engine.bind.impl.BookmarkBinder;
import nz.org.riskscape.engine.bind.impl.BooleanBinder;
import nz.org.riskscape.engine.bind.impl.ConfigStringBinder;
import nz.org.riskscape.engine.bind.impl.CoordinateReferenceSystemBinder;
import nz.org.riskscape.engine.bind.impl.EnumBinder;
import nz.org.riskscape.engine.bind.impl.EnvelopeBinder;
import nz.org.riskscape.engine.bind.impl.ExpressionBinder;
import nz.org.riskscape.engine.bind.impl.FormatBinder;
import nz.org.riskscape.engine.bind.impl.FunctionBinder;
import nz.org.riskscape.engine.bind.impl.FunctionCallPrototypeBinder;
import nz.org.riskscape.engine.bind.impl.IdentityBinder;
import nz.org.riskscape.engine.bind.impl.NumberBinder;
import nz.org.riskscape.engine.bind.impl.SortByBinder;
import nz.org.riskscape.engine.bind.impl.StringBinder;
import nz.org.riskscape.engine.bind.impl.TypeBinder;
import nz.org.riskscape.engine.bind.impl.UriBinder;
import nz.org.riskscape.engine.data.relation.AttributeMapBinder;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.problem.ResultOrProblems;

public class DefaultBindingContext
implements BindingContext {
    public static final List<ParameterBinder> DEFAULT_BINDERS = ImmutableList.of((Object)((Object)new FunctionBinder()), (Object)((Object)new BooleanBinder()), (Object)((Object)new EnumBinder()), (Object)((Object)new BookmarkBinder()), (Object)((Object)new TypeBinder()), (Object)((Object)new NumberBinder()), (Object)((Object)new EnvelopeBinder()), (Object)((Object)new CoordinateReferenceSystemBinder()), (Object)((Object)new AttributeMapBinder()), (Object)((Object)new SortByBinder()), (Object)((Object)new ExpressionBinder()), (Object)((Object)new FunctionCallPrototypeBinder()), (Object[])new ParameterBinder[]{new UriBinder(), new StringBinder(), new ArgumentListBinder(), new FormatBinder(), new IdentityBinder(), new ConfigStringBinder()});
    private List<ParameterBinder> binders;
    private SRIDSet sridSet;
    private Project project;
    private final URI relativeTo;
    private final RealizationContext realizationContext;
    private final Path tempDir;

    private DefaultBindingContext(List<ParameterBinder> binders, SRIDSet sridSet, Project project, URI relativeTo, RealizationContext context, Path tempDir) {
        this.binders = binders;
        this.sridSet = sridSet;
        this.project = project;
        this.relativeTo = relativeTo;
        this.realizationContext = context;
        this.tempDir = tempDir;
    }

    public DefaultBindingContext(Project project, RealizationContext context) {
        this(project, context, null);
    }

    public DefaultBindingContext(Project project, RealizationContext context, Path tempDir) {
        this(project.getEngine().getBinders().getAll(), project.getSridSet(), project, project.getRelativeTo(), context, tempDir);
    }

    public DefaultBindingContext withNewRelativeTo(URI newRelativeTo) {
        return new DefaultBindingContext(this.binders, this.sridSet, this.project, newRelativeTo, this.realizationContext, this.tempDir);
    }

    public Optional<ParameterBinder> getBinder(Class<?> fromType, Class<?> toType) {
        return this.binders.stream().filter(pt -> pt.canBind(fromType, toType)).findFirst();
    }

    private ParameterBinder getReqdBinder(Class<?> fromType, Class<?> toType) {
        return this.getBinder(fromType, toType).orElseThrow(() -> new NoBindingAvailableException(fromType, toType));
    }

    public <T> ResultOrProblems<T> bind(Object value, Class<T> expectedType) {
        Object normalizedValue = this.normalizeValue(value, expectedType);
        return this.getReqdBinder(normalizedValue.getClass(), expectedType).bindValue((BindingContext)this, normalizedValue, expectedType);
    }

    private Object normalizeValue(Object value, Class<?> expectedType) {
        if (value instanceof ConfigString) {
            ConfigString cs = (ConfigString)value;
            if (expectedType != ConfigString.class) {
                return cs.toString();
            }
        }
        return value;
    }

    @Deprecated
    public Object bind(Parameter param, String value) {
        ParameterBinder binder = this.getBinder(String.class, param.getType()).orElseThrow(() -> new UnbindableParameterException(param, "No binder available for type %s", new Object[]{param.getType()}));
        return binder.bind((BindingContext)this, param, value);
    }

    public void validateBoundParameters(List<Parameter> parameters, Map<String, List<?>> boundParameters) throws InvalidBoundParametersException {
        for (Parameter declared : parameters) {
            List supplied = boundParameters.getOrDefault(declared.getName(), Collections.emptyList());
            if (supplied == null) {
                throw new NullPointerException("bound parameter map should never map to a null list! null mapped key was " + declared.getName());
            }
            if (!declared.hasCorrectArity(supplied.size())) {
                throw new InvalidBoundParametersException(String.format("Parameter '%s' is missing values, has %d, needs %d", declared.getName(), supplied.size(), declared.getMinRequired()));
            }
            for (Object param : supplied) {
                if (param == null) {
                    throw new InvalidBoundParametersException(String.format("Null value supplied for parameter '%s'", param));
                }
                if (declared.getType().isInstance(param)) continue;
                throw new InvalidBoundParametersException(String.format("Value '%s' for parameter '%s' is of wrong type.  Was %s, should have been %s", param, declared, param.getClass(), declared.getType()));
            }
        }
    }

    public Engine getEngine() {
        return this.project.getEngine();
    }

    public Path getTempDirectory() {
        if (this.tempDir == null) {
            return this.getEngine().getTempDirectory();
        }
        return this.tempDir;
    }

    @Generated
    public List<ParameterBinder> getBinders() {
        return this.binders;
    }

    @Generated
    public void setBinders(List<ParameterBinder> binders) {
        this.binders = binders;
    }

    @Generated
    public SRIDSet getSridSet() {
        return this.sridSet;
    }

    @Generated
    public void setSridSet(SRIDSet sridSet) {
        this.sridSet = sridSet;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public void setProject(Project project) {
        this.project = project;
    }

    @Generated
    public URI getRelativeTo() {
        return this.relativeTo;
    }

    @Generated
    public RealizationContext getRealizationContext() {
        return this.realizationContext;
    }
}

