/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import com.codahale.metrics.Gauge;
import com.google.common.util.concurrent.AtomicDouble;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.Objects;
import javax.management.NotificationEmitter;
import javax.management.openmbean.CompositeData;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryMonitoring {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemoryMonitoring.class);
    public final float warningRatio = 0.75f;
    public final float badRatio = 0.85f;
    public final float postFullGCwarningRatio = 0.55f;
    public final float postFullGCbadRatio = 0.7f;
    MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private final AtomicDouble postFullGCRatio = new AtomicDouble(0.0);

    public MemoryMonitoring() {
        this.setupListening();
    }

    final void setupListening() {
        for (GarbageCollectorMXBean gcBean : this.gcBeans) {
            if (!(gcBean instanceof NotificationEmitter)) continue;
            ((NotificationEmitter)((Object)gcBean)).addNotificationListener((notification, handback) -> {
                CompositeData compositeData = (CompositeData)notification.getUserData();
                String gcAction = compositeData.get("gcAction").toString();
                if (gcAction.equals("end of major GC")) {
                    HeapInfo current = new HeapInfo(this.memoryMXBean.getHeapMemoryUsage());
                    this.postFullGCRatio.set(current.usedRatio());
                    log.info("Major GC Event - max: {}, used: {}, free: {}", new Object[]{MemoryMonitoring.formatBytes(current.max), MemoryMonitoring.formatBytes(current.used), MemoryMonitoring.formatBytes(current.max - current.used)});
                }
            }, null, null);
        }
    }

    protected static String formatBytes(long numBytes) {
        int unitIdx;
        double divided = Math.abs(numBytes);
        String[] units = new String[]{"bytes", "Kbytes", "Mbytes", "Gbytes"};
        for (unitIdx = 0; divided > 1024.0 && unitIdx < units.length; ++unitIdx, divided /= 1024.0) {
        }
        return String.format("%.1f%s", divided, units[unitIdx]);
    }

    public Gauge<Level> getCurrentHeapFreeLevel() {
        return () -> {
            double ratio = new HeapInfo(this.memoryMXBean.getHeapMemoryUsage()).usedRatio();
            Objects.requireNonNull(this);
            if (ratio > (double)0.85f) {
                return Level.BAD;
            }
            Objects.requireNonNull(this);
            if (ratio > 0.75) {
                return Level.WARNING;
            }
            return Level.OK;
        };
    }

    public Gauge<Level> getPostFullGCHeapFreeLevel() {
        return () -> {
            double ratio = this.postFullGCRatio.get();
            Objects.requireNonNull(this);
            if (ratio > (double)0.7f) {
                return Level.BAD;
            }
            Objects.requireNonNull(this);
            if (ratio > (double)0.55f) {
                return Level.WARNING;
            }
            return Level.OK;
        };
    }

    public static enum Level {
        OK,
        WARNING,
        BAD;


        public boolean isWarningOrWorse() {
            return this.ordinal() >= WARNING.ordinal();
        }
    }

    private class HeapInfo {
        long max;
        long used;

        HeapInfo(MemoryUsage usage) {
            this.max = usage.getMax();
            this.used = usage.getUsed();
        }

        public String toString() {
            return String.format("Heap[max=%s, used=%s, perc=%.1f]", MemoryMonitoring.formatBytes(this.max), MemoryMonitoring.formatBytes(this.used), this.usedPercentage());
        }

        public double usedPercentage() {
            return (double)this.used / (double)this.max * 100.0;
        }

        public double usedRatio() {
            return (double)this.used / (double)this.max;
        }
    }
}

