/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import com.csvreader.CsvReader;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.wfs.WFSDataStoreFactory;

public class FeatureSources {
    public static final String GEOMETRY_COLUMN_NAME = "the_geom";
    public static final int WFS_TIMEOUT_MS = 600000;

    public static SimpleFeatureSource open(String target, Optional<String> typeName) {
        if (target.startsWith("http") && target.toLowerCase().contains("wfs")) {
            return FeatureSources.openDataSource(target, (Map<String, Object>)ImmutableMap.of((Object)WFSDataStoreFactory.TIMEOUT.key, (Object)600000, (Object)WFSDataStoreFactory.URL.key, (Object)target), typeName);
        }
        return FeatureSources.open(new File(target), typeName);
    }

    public static SimpleFeatureSource open(File target) {
        return FeatureSources.open(target, Optional.empty());
    }

    public static SimpleFeatureSource open(File target, Optional<String> requestedType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("url", target.toURI().toURL());
            if (target.getName().endsWith(".csv")) {
                FeatureSources.setCsvOptions(target, map);
            } else if (target.getName().endsWith(".shp")) {
                map.put(ShapefileDataStoreFactory.MEMORY_MAPPED.key, true);
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return FeatureSources.openDataSource(target.getName(), map, requestedType);
    }

    private static void setCsvOptions(File csvFile, Map<String, Object> map) {
        boolean useWKT = true;
        if (csvFile.exists()) {
            useWKT = false;
            try (BufferedReader reader = new BufferedReader(new FileReader(csvFile));
                 StringReader header = new StringReader(reader.readLine());){
                String[] headers;
                CsvReader csvReader = new CsvReader((Reader)header);
                csvReader.readHeaders();
                for (String columnHeader : headers = csvReader.getHeaders()) {
                    if (!GEOMETRY_COLUMN_NAME.equals(columnHeader)) continue;
                    useWKT = true;
                    break;
                }
                csvReader.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read from CSV file", e);
            }
        }
        if (useWKT) {
            map.put("strategy", "wkt");
            map.put("wktField", GEOMETRY_COLUMN_NAME);
        } else {
            map.put("strategy", "guess");
        }
    }

    private static SimpleFeatureSource openDataSource(String source, Map<String, Object> map, Optional<String> requestedType) {
        SimpleFeatureSource featureSource;
        String typeName;
        DataStore dataStore;
        try {
            dataStore = DataStoreFinder.getDataStore(map);
            if (dataStore == null) {
                throw new RuntimeException(String.format("Could not read features from %s - is it in a supported format?", source));
            }
            typeName = requestedType.orElse(dataStore.getTypeNames()[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not extract features from %s, reason: %s", source, e.getMessage()), e);
        }
        try {
            featureSource = dataStore.getFeatureSource(typeName);
        }
        catch (IOException e) {
            throw new RuntimeException("Unhandled error trying to access features: %s", e);
        }
        return DataUtilities.simple((FeatureSource)featureSource);
    }
}

