/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.config.Config;
import nz.org.riskscape.config.ConfigProblems;
import nz.org.riskscape.config.ConfigSection;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.ObjectAlreadyExistsException;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.ProjectBuilder;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.data.BookmarkFactory;
import nz.org.riskscape.engine.function.FunctionProvider;
import nz.org.riskscape.engine.geo.GeometryValidation;
import nz.org.riskscape.engine.ini.IdentifiedObjectBuilder;
import nz.org.riskscape.engine.ini.IniFileFunctionBuilder;
import nz.org.riskscape.engine.ini.IniFileModelBuilder2;
import nz.org.riskscape.engine.ini.IniFileParameterBuilder;
import nz.org.riskscape.engine.plugin.Plugin;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.resource.UriHelper;
import nz.org.riskscape.engine.types.TypeProvider;
import nz.org.riskscape.engine.typexp.IniFileTypeBuilder;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.TokenTypes;

public class DefaultProjectBuilder
implements ProjectBuilder {
    public static final String PROJECT_KEY = "project";
    private static final String VALIDATE_GEOMETRY_KEY = "validate-geometry";
    private Config config;
    private final LinkedList<Problem> problems = new LinkedList();

    @Override
    public ResultOrProblems<Project> init(Project project) {
        Engine engine = project.getEngine();
        List plugins = engine.getPlugins();
        this.config = project.getConfig();
        project.setRelativeTo(this.config.getRootLocation());
        List<IdentifiedObjectBuilder<?>> iniBuilders = Arrays.asList(new BookmarkFactory(), new IniFileTypeBuilder(project), new IniFileModelBuilder2(project), new IniFileFunctionBuilder(project), new IniFileParameterBuilder(project));
        for (ConfigSection section : this.config.getAll()) {
            String sectionKey = section.getName();
            if (sectionKey.startsWith(PROJECT_KEY)) {
                this.parseProjectSection(section, project, iniBuilders);
                continue;
            }
            boolean ignored = true;
            for (IdentifiedObjectBuilder identifiedObjectBuilder : iniBuilders) {
                if (!sectionKey.startsWith(identifiedObjectBuilder.getKeyword())) continue;
                String id = sectionKey.replaceFirst(identifiedObjectBuilder.getKeyword(), "");
                if ((id = TokenTypes.stripQuotes((String)id).trim()).isBlank()) {
                    this.problems.add(Problems.foundWith((Object)("[" + sectionKey + "]"), (Problems)GeneralProblems.get().required((Object)"id")));
                } else {
                    identifiedObjectBuilder.addToProject(project, id, section);
                }
                ignored = false;
                break;
            }
            if (!ignored) continue;
            ArrayList allowedKeys = Lists.newArrayList((Object[])new String[]{PROJECT_KEY});
            iniBuilders.stream().forEach(b -> allowedKeys.add(b.getKeyword()));
            this.problems.add(ConfigProblems.get().spuriousSectionInProject("[" + sectionKey + "]", section.getLocation(), (List)allowedKeys));
        }
        for (Plugin plugin : plugins) {
            plugin.supportsFeature(TypeProvider.class).ifPresent(tp -> tp.addTypes(project, p -> this.problems.add((Problem)p)));
        }
        for (Plugin plugin : plugins) {
            plugin.supportsFeature(FunctionProvider.class).ifPresent(tp -> tp.addFunctions(project, p -> this.problems.add((Problem)p)));
        }
        for (Plugin plugin : plugins) {
            try {
                this.problems.addAll(plugin.initializeProject(project, engine));
            }
            catch (ObjectAlreadyExistsException e) {
                throw e;
            }
            catch (Throwable ex) {
                return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((Throwable)ex, (String)"Failed to initialize plugin %s", (Object[])new Object[]{plugin.getDescriptor()}).withChildren(new Problems[]{Problems.caught((Throwable)ex)})});
            }
        }
        return ResultOrProblems.of((Object)project, this.problems);
    }

    private void parseProjectSection(ConfigSection section, Project project, List<IdentifiedObjectBuilder<?>> iniBuilders) {
        BindingContext bindingContext = project.newBindingContext();
        section.getOne("output-base-location").ifPresent(or -> or.flatMap(value -> UriHelper.uriFromLocation((String)value, (URI)project.getRelativeTo())).ifElse(uri -> project.setOutputBaseLocation(uri), ps -> this.problems.add(Problems.foundWith(Parameter.class, (String)"output-base-location", (List)ps))));
        section.getOne(VALIDATE_GEOMETRY_KEY).ifPresent(or -> or.flatMap(value -> bindingContext.bind(value, GeometryValidation.class)).ifElse(mode -> project.setGeometryValidation(mode), ps -> this.problems.add(Problems.foundWith(Parameter.class, (String)VALIDATE_GEOMETRY_KEY, (List)ps))));
    }

    @Generated
    public DefaultProjectBuilder() {
    }
}

