/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.config.Config;
import nz.org.riskscape.engine.DefaultFunctionResolver;
import nz.org.riskscape.engine.DefaultFunctionSet;
import nz.org.riskscape.engine.DefaultIdentifiedLocator;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.FunctionSet;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.DefaultBindingContext;
import nz.org.riskscape.engine.bind.UserDefinedParameter;
import nz.org.riskscape.engine.data.Bookmark;
import nz.org.riskscape.engine.data.Bookmarks;
import nz.org.riskscape.engine.data.DefaultBookmarks;
import nz.org.riskscape.engine.function.FunctionResolver;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.geo.GeometryValidation;
import nz.org.riskscape.engine.model.IdentifiedModel;
import nz.org.riskscape.engine.rl.DefaultExpressionRealizer;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.typeset.TypeSet;
import nz.org.riskscape.engine.typexp.DefaultTypeBuilder;
import nz.org.riskscape.engine.typexp.TypeBuilder;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.crs.DefaultGeographicCRS;

public class DefaultProject
extends DefaultIdentifiedLocator
implements Project {
    private final Engine engine;
    private final SRIDSet sridSet;
    private Config config;
    private CoordinateReferenceSystem defaultCrs = DefaultGeographicCRS.WGS84;
    private URI relativeTo;
    private URI outputBaseLocation;
    private GeometryValidation geometryValidation;
    private final Bookmarks bookmarks = this.put(new DefaultBookmarks());
    private final FunctionSet functionSet = this.put(new DefaultFunctionSet());
    private final TypeSet typeSet;
    private final IdentifiedCollection<IdentifiedModel> identifiedModels = this.put(new IdentifiedCollection.Base(IdentifiedModel.class));
    private final IdentifiedCollection<UserDefinedParameter> parameterTemplates = this.put(new IdentifiedCollection.Base(UserDefinedParameter.class));
    private TypeBuilder typeBuilder;

    public DefaultProject(Engine engine, Config config) {
        this.engine = engine;
        this.typeSet = this.put(new TypeSet(engine.getTypeRegistry()));
        this.sridSet = new SRIDSet(this.getProblemSink());
        this.config = config;
        this.setGeometryValidation(GeometryValidation.ERROR);
    }

    public void validate(Consumer<Problem> problemConsumer) {
        BindingContext context = this.newBindingContext();
        this.typeSet.validate(problemConsumer);
        this.functionSet.validate(context, problemConsumer);
        this.bookmarks.validate((Project)this, problemConsumer);
    }

    public BindingContext newBindingContext() {
        return this.newBindingContext(this.newRealizationContext());
    }

    public BindingContext newBindingContext(RealizationContext realizationContext) {
        return new DefaultBindingContext(this, realizationContext);
    }

    public void add(Bookmark bookmark) {
        this.bookmarks.add((Identified)bookmark);
    }

    public void add(IdentifiedFunction function) {
        this.functionSet.add((Identified)function);
    }

    public URI getOutputBaseLocation() {
        if (this.outputBaseLocation != null) {
            return this.outputBaseLocation;
        }
        return this.getRelativeTo().resolve("output/");
    }

    public TypeBuilder getTypeBuilder() {
        if (this.typeBuilder == null) {
            this.typeBuilder = new DefaultTypeBuilder(this.getTypeSet());
        }
        return this.typeBuilder;
    }

    public RealizationContext newRealizationContext() {
        final DefaultFunctionResolver functionResolver = new DefaultFunctionResolver();
        return new RealizationContext(){
            ExpressionRealizer realizer = new DefaultExpressionRealizer(this);
            Cache<Object, Object> cache;
            HashMap<RekeyedStruct, Struct> structs;
            Struct empty;
            {
                this.cache = CacheBuilder.newBuilder().softValues().concurrencyLevel(Math.max(1, DefaultProject.this.engine.getPipelineExecutor().getNumThreads())).build();
                this.structs = new HashMap();
                this.empty = this.normalizeStruct(Struct.EMPTY_STRUCT);
            }

            public ExpressionRealizer getExpressionRealizer() {
                return this.realizer;
            }

            public Project getProject() {
                return DefaultProject.this;
            }

            public FunctionResolver getFunctionResolver() {
                return functionResolver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Struct normalizeStruct(Struct struct) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    return this.structs.computeIfAbsent(new RekeyedStruct(struct), key -> key.source);
                }
            }

            public ProblemSink getProblemSink() {
                return DefaultProject.this.engine.getProblemSink();
            }

            public <T> T getOrComputeFromCache(Object cacheKey, Class<T> expectedType, Function<Object, T> compute) {
                try {
                    Object computed = this.cache.get(cacheKey, () -> compute.apply(cacheKey));
                    return expectedType.cast(computed);
                }
                catch (ExecutionError | UncheckedExecutionException | ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RiskscapeException) {
                        throw (RiskscapeException)cause;
                    }
                    throw new RiskscapeException((Problems)Problems.caught((Throwable)e.getCause()));
                }
            }
        };
    }

    public URI getRelativeTo() {
        if (this.relativeTo == null) {
            return Paths.get("", new String[0]).toUri();
        }
        return this.relativeTo;
    }

    @Override
    public boolean hasCollectionOf(Class<? extends Identified> identifiedClass) {
        return super.hasCollectionOf(identifiedClass) || this.getEngine().hasCollectionOf(identifiedClass);
    }

    @Override
    public <T extends Identified> IdentifiedCollection<T> getCollectionByClass(Class<T> collectionClass) {
        if (this.engine.hasCollectionOf(collectionClass)) {
            return this.engine.getCollectionByClass(collectionClass);
        }
        return super.getCollectionByClass(collectionClass);
    }

    @Override
    public Set<Class<? extends Identified>> getCollectionClasses() {
        return Sets.union(super.getCollectionClasses(), (Set)this.engine.getCollectionClasses());
    }

    public final ProblemSink getProblemSink() {
        return this.engine.getProblemSink();
    }

    public void setGeometryValidation(GeometryValidation mode) {
        this.geometryValidation = mode;
        this.sridSet.setValidationPostReproject(mode);
    }

    @Generated
    public Engine getEngine() {
        return this.engine;
    }

    @Generated
    public SRIDSet getSridSet() {
        return this.sridSet;
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    @Generated
    public CoordinateReferenceSystem getDefaultCrs() {
        return this.defaultCrs;
    }

    @Generated
    public void setDefaultCrs(CoordinateReferenceSystem defaultCrs) {
        this.defaultCrs = defaultCrs;
    }

    @Generated
    public void setRelativeTo(URI relativeTo) {
        this.relativeTo = relativeTo;
    }

    @Generated
    public void setOutputBaseLocation(URI outputBaseLocation) {
        this.outputBaseLocation = outputBaseLocation;
    }

    @Generated
    public GeometryValidation getGeometryValidation() {
        return this.geometryValidation;
    }

    @Generated
    public Bookmarks getBookmarks() {
        return this.bookmarks;
    }

    @Generated
    public FunctionSet getFunctionSet() {
        return this.functionSet;
    }

    @Generated
    public TypeSet getTypeSet() {
        return this.typeSet;
    }

    @Generated
    public IdentifiedCollection<IdentifiedModel> getIdentifiedModels() {
        return this.identifiedModels;
    }

    @Generated
    public IdentifiedCollection<UserDefinedParameter> getParameterTemplates() {
        return this.parameterTemplates;
    }

    private static class RekeyedStruct {
        private final Struct source;

        public boolean equals(Object obj) {
            if (obj instanceof RekeyedStruct) {
                RekeyedStruct rhs = (RekeyedStruct)obj;
                Iterator lhsMembers = this.source.getMembers().iterator();
                Iterator rhsMembers = rhs.source.getMembers().iterator();
                while (lhsMembers.hasNext()) {
                    if (!rhsMembers.hasNext()) {
                        return false;
                    }
                    Struct.StructMember lhsMember = (Struct.StructMember)lhsMembers.next();
                    Struct.StructMember rhsMember = (Struct.StructMember)rhsMembers.next();
                    if (!lhsMember.getKey().equals(rhsMember.getKey())) {
                        return false;
                    }
                    if (Nullable.is((Type)lhsMember.getType()) != Nullable.is((Type)rhsMember.getType())) {
                        return false;
                    }
                    if (Nullable.strip((Type)lhsMember.getType()) == Nullable.strip((Type)rhsMember.getType())) continue;
                    return false;
                }
                return !rhsMembers.hasNext();
            }
            return false;
        }

        public int hashCode() {
            return this.source.hashCode();
        }

        @Generated
        public RekeyedStruct(Struct source) {
            this.source = source;
        }
    }
}

