/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.IdentifiedLocator;

public class DefaultIdentifiedLocator
implements IdentifiedLocator {
    private final Map<Class<? extends Identified>, IdentifiedCollection<?>> collections = new HashMap();

    public <T extends Identified> IdentifiedCollection<T> getCollectionByClass(Class<T> identifiedClass) {
        IdentifiedCollection<?> collection = this.collections.get(identifiedClass);
        if (collection == null) {
            throw new IllegalArgumentException(String.valueOf(identifiedClass) + " is not registered in : " + String.valueOf(this));
        }
        if (collection.getCollectionClass() == identifiedClass) {
            return collection;
        }
        throw new AssertionError((Object)"somehow a collection class has been registered with the wrong type");
    }

    public <T extends Identified, U extends IdentifiedCollection<T>> U getCollection(Class<U> collectionClass) {
        return (U)((IdentifiedCollection)collectionClass.cast(this.getCollectionByClass(this.findIdentifiedType(collectionClass))));
    }

    private Class<? extends Identified> findIdentifiedType(Class<?> collectionClass) {
        ArrayList<Type> types = new ArrayList<Type>();
        types.add(collectionClass.getGenericSuperclass());
        types.addAll(Arrays.asList(collectionClass.getGenericInterfaces()));
        for (Type type : types) {
            ParameterizedType pType;
            if (!(type instanceof ParameterizedType) || !IdentifiedCollection.class.isAssignableFrom((Class)(pType = (ParameterizedType)type).getRawType())) continue;
            return (Class)pType.getActualTypeArguments()[0];
        }
        throw new RuntimeException("Could not find parameterized type");
    }

    public void registerCollection(IdentifiedCollection<?> collection) {
        this.collections.put(collection.getCollectionClass(), collection);
    }

    public boolean hasCollectionOf(Class<? extends Identified> identifiedClass) {
        return this.collections.containsKey(identifiedClass);
    }

    public Set<Class<? extends Identified>> getCollectionClasses() {
        return Collections.unmodifiableSet(this.collections.keySet());
    }

    protected <T extends IdentifiedCollection<?>> T put(T collection) {
        this.registerCollection(collection);
        return collection;
    }

    public String toString() {
        return String.format("DefaultIdentifiedLocator(collections=%s)", this.getCollectionClasses().stream().map(Class::getSimpleName).collect(Collectors.joining(", ", "[", "]")));
    }
}

