/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import nz.org.riskscape.engine.FunctionSet;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.IdentifiedException;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.function.FunctionResolver;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.OperatorResolver;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.BinaryOperation;
import nz.org.riskscape.rl.ast.FunctionCall;

public class DefaultFunctionSet
extends IdentifiedCollection.Base<IdentifiedFunction>
implements OperatorResolver,
FunctionSet {
    private final List<OperatorResolver> operatorResolvers = Lists.newArrayList();

    public void validate(BindingContext context, Consumer<Problem> problemConsumer) {
        this.results.values().forEach(handle -> {
            ResultOrProblems function = handle.getResult();
            if (function.hasProblems()) {
                problemConsumer.accept(GeneralProblems.get().failedToValidate(IdentifiedFunction.class, handle.getId(), handle.getResource()).withSeverity(Problem.max((Collection)function.getProblems())).withChildren(function.getProblems()));
            } else {
                ResultOrProblems validationProblems = ((IdentifiedFunction)function.get()).validate(context.getRealizationContext());
                if (validationProblems.hasProblems()) {
                    problemConsumer.accept(GeneralProblems.get().failedToValidate(IdentifiedFunction.class, handle.getId(), handle.getResource()).withSeverity(Problem.max((Collection)validationProblems.getProblems())).withChildren(validationProblems.getProblems()));
                }
            }
        });
    }

    public ResultOrProblems<RiskscapeFunction> resolve(RealizationContext context, FunctionCall functionCall, Type inputType, List<Type> argumentTypes, FunctionResolver resolver) {
        String functionId = functionCall.getIdentifier().value;
        try {
            return resolver.resolve(context, functionCall, inputType, argumentTypes, (IdentifiedFunction)this.get(functionId));
        }
        catch (IdentifiedException e) {
            return ResultOrProblems.failed((Problem[])new Problem[]{e.getProblem()});
        }
    }

    public Optional<RiskscapeFunction> resolve(RealizationContext context, BinaryOperation operation, Type inputType, Type lhs, Type rhs) {
        return this.operatorResolvers.stream().map(r -> r.resolve(context, operation, inputType, lhs, rhs)).filter(p -> p.isPresent()).map(Optional::get).findFirst();
    }

    public void insertFirst(OperatorResolver operatorResolver) {
        this.operatorResolvers.add(0, operatorResolver);
    }

    public void insertLast(OperatorResolver operatorResolver) {
        this.operatorResolvers.add(operatorResolver);
    }
}

