/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.CoercingFunctionWrapper;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.FunctionResolver;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.NullSafeFunction;
import nz.org.riskscape.engine.function.OverloadedFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.MissingFunctionException;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.types.eqrule.Coercer;
import nz.org.riskscape.engine.types.varule.Variance;
import nz.org.riskscape.engine.typeset.TypeSet;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFunctionResolver
implements FunctionResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultFunctionResolver.class);
    private static final ProblemCode NO_SUCH_MEMBER = ExpressionProblems.get().noSuchStructMember("", Collections.emptyList()).getCode();

    public static <T> T evaluateConstant(RealizationContext context, FunctionCall functionCall, int argIndex, Class<T> requiredJavaType, Type requiredType) throws ProblemException {
        FunctionCall.Argument argument = (FunctionCall.Argument)functionCall.getArguments().get(argIndex);
        Expression expression = argument.getExpression();
        ResultOrProblems constantExpressionOr = context.getExpressionRealizer().realize((Type)Struct.EMPTY_STRUCT, expression);
        List problems = constantExpressionOr.getProblems();
        if (Problem.hasErrors((Collection)problems)) {
            if (problems.stream().allMatch(prob -> prob.getCode().equals(NO_SUCH_MEMBER))) {
                throw new ProblemException((Problems)ExpressionProblems.get().constantRequired(expression));
            }
            throw new ProblemException(problems);
        }
        RealizedExpression realized = (RealizedExpression)constantExpressionOr.get();
        if (!requiredJavaType.equals(realized.getResultType().internalType())) {
            throw new ProblemException((Problems)TypeProblems.get().mismatch((Object)expression, requiredType, realized.getResultType()));
        }
        Object returned = ((RealizedExpression)constantExpressionOr.get()).evaluate((Object)Tuple.EMPTY_TUPLE);
        return requiredJavaType.cast(returned);
    }

    public ResultOrProblems<RiskscapeFunction> resolve(RealizationContext context, FunctionCall functionCall, Type inputType, List<Type> argumentTypes, IdentifiedFunction function) {
        return this.adaptFunction(context, functionCall, function, inputType, argumentTypes).map(rf -> this.normalizeReturnType(context, functionCall, (RiskscapeFunction)rf));
    }

    private boolean all(List<SetPair> pairs, Predicate<SetPair> predicate) {
        for (SetPair pair : pairs) {
            if (predicate.test(pair)) continue;
            return false;
        }
        return true;
    }

    private <T> boolean any(List<T> pairs, Predicate<T> predicate) {
        for (T pair : pairs) {
            if (!predicate.test(pair)) continue;
            return true;
        }
        return false;
    }

    private ResultOrProblems<RiskscapeFunction> adaptFunction(RealizationContext context, FunctionCall functionCall, IdentifiedFunction targetFunction, Type inputType, List<Type> givenTypes) {
        RiskscapeFunction found;
        TypeSet typeSet = context.getProject().getTypeSet();
        log.debug("Attempting to adapt function {} against {}", (Object)targetFunction, givenTypes);
        List<RiskscapeFunction> alternatives = targetFunction.getOverloaded().map(ol -> ol.getAlternatives()).orElse(Collections.emptyList());
        if (alternatives.size() > 0 && (found = this.searchForBestAlternative(typeSet, alternatives, givenTypes)) != null) {
            return ResultOrProblems.of((Object)found);
        }
        log.debug("No overloaded functions from {} match", (Object)targetFunction);
        if (targetFunction.getOverloaded().map(OverloadedFunction::ignoreThis).orElse(false).booleanValue()) {
            return ResultOrProblems.error((RiskscapeException)new MissingFunctionException(functionCall, givenTypes, targetFunction));
        }
        RealizableFunction realizable = targetFunction.getRealizable().orElse(null);
        if (realizable != null) {
            ResultOrProblems realizationResult;
            log.debug("Function {} is realizable, attempting realization...", (Object)targetFunction);
            Object adapted = realizable.isDoTypeAdaptation() ? this.adaptFunction1(typeSet, (RiskscapeFunction)targetFunction, givenTypes) : targetFunction;
            if (adapted == targetFunction || adapted == null) {
                realizationResult = realizable.realize(context, functionCall, givenTypes);
            } else {
                ArrayList<Type> realizeAgainst = new ArrayList<Type>(givenTypes.size());
                for (int i = 0; i < givenTypes.size(); ++i) {
                    realizeAgainst.add(this.getCoercedArgumentType((RiskscapeFunction)adapted, i, givenTypes.get(i)));
                }
                realizationResult = realizable.realize(context, functionCall, realizeAgainst).map(arg_0 -> this.lambda$adaptFunction$3(targetFunction, (RiskscapeFunction)adapted, arg_0));
            }
            if (realizationResult.hasErrors()) {
                return realizationResult.composeProblems((s, c) -> Problems.foundWith(RiskscapeFunction.class, (String)targetFunction.getId(), (List)c));
            }
            List<SetPair> finalTypes = this.zipArgTypes(typeSet, givenTypes, ((RiskscapeFunction)(realizationResult = realizationResult.drainWarnings((Consumer)context.getProblemSink(), (severity, children) -> Problems.foundWith(RiskscapeFunction.class, (String)targetFunction.getId(), (Problem[])new Problem[0]).withSeverity(severity).withChildren(children))).get()).getArgumentTypes());
            if (!this.all(finalTypes, SetPair::isAssignable)) {
                return ResultOrProblems.failed((Problem[])new Problem[]{((ArgsProblems)Problems.get(ArgsProblems.class)).realizableDidNotMatch(targetFunction, givenTypes)});
            }
            return realizationResult;
        }
        RiskscapeFunction toUse = this.adaptFunction1(typeSet, (RiskscapeFunction)targetFunction, givenTypes);
        if (toUse == null) {
            return ResultOrProblems.error((RiskscapeException)new MissingFunctionException(functionCall, givenTypes, targetFunction));
        }
        return ResultOrProblems.of((Object)toUse);
    }

    private Type getCoercedArgumentType(RiskscapeFunction function, int argumentIndex, Type givenType) {
        return function.isA(NullSafeFunction.class).map(nullSafe -> {
            boolean stripNullable = nullSafe.getNotNullableIndices()[argumentIndex];
            Type coerced = this.getCoercedArgumentType(nullSafe.getTarget(), argumentIndex, givenType);
            if (stripNullable) {
                return Nullable.strip((Type)coerced);
            }
            return coerced;
        }).orElseGet(() -> function.isA(CoercingFunctionWrapper.class).map(coerced -> {
            Type coercedType = coerced.getCoercers().get(argumentIndex).map(Coercer::getTargetType).orElse(givenType);
            return this.getCoercedArgumentType(coerced.getWrapped(), argumentIndex, coercedType);
        }).orElse(givenType));
    }

    private RiskscapeFunction rewrap(RiskscapeFunction target, RiskscapeFunction realized, RiskscapeFunction adapted) {
        if (adapted == target) {
            return realized;
        }
        if (adapted instanceof NullSafeFunction) {
            NullSafeFunction nsFunction = (NullSafeFunction)adapted;
            return NullSafeFunction.wrap((RiskscapeFunction)this.rewrap(target, realized, nsFunction.getTarget()));
        }
        if (adapted instanceof CoercingFunctionWrapper) {
            CoercingFunctionWrapper cwFunction = (CoercingFunctionWrapper)adapted;
            return CoercingFunctionWrapper.wrap(this.rewrap(target, realized, cwFunction.getWrapped()), cwFunction.getCoercers());
        }
        throw new AssertionError((Object)("wrong function type " + String.valueOf(adapted.getClass())));
    }

    private boolean isViableAlternative(RiskscapeFunction alternative, List<Type> givenTypes) {
        return givenTypes.size() <= alternative.getArgumentTypes().size();
    }

    private RiskscapeFunction searchForBestAlternative(TypeSet typeSet, List<RiskscapeFunction> alternatives, List<Type> givenTypes) {
        List pairedArgs;
        RiskscapeFunction alternative;
        List functionsAndPairedArgs = alternatives.stream().filter(rf -> this.isViableAlternative((RiskscapeFunction)rf, givenTypes)).map(rf -> Pair.of((Object)rf, this.zipArgTypes(typeSet, givenTypes, rf.getArgumentTypes()))).collect(Collectors.toList());
        log.debug("Searching for perfect match for types {}...", givenTypes);
        for (Object pair : functionsAndPairedArgs) {
            alternative = (RiskscapeFunction)pair.getLeft();
            pairedArgs = (List)pair.getRight();
            if (!this.all(pairedArgs, sp -> sp.testVariance() == Variance.EQUAL)) continue;
            log.debug("...Found it.", (Object)alternative.getArgumentTypes());
            return alternative;
        }
        log.debug("Searching a covariant match for types {}...", givenTypes);
        for (Object pair : functionsAndPairedArgs) {
            alternative = (RiskscapeFunction)pair.getLeft();
            pairedArgs = (List)pair.getRight();
            if (!this.all(pairedArgs, sp -> sp.isAssignable())) continue;
            log.debug("...Found it.", (Object)alternative.getArgumentTypes());
            return alternative;
        }
        log.debug("Searching for an equivalent match for types {}...", givenTypes);
        ArrayList<RiskscapeFunction> coerced = new ArrayList<RiskscapeFunction>(alternatives.size());
        for (Pair pair : functionsAndPairedArgs) {
            RiskscapeFunction alternative2 = (RiskscapeFunction)pair.getLeft();
            List pairedArgs2 = (List)pair.getRight();
            List<Optional<Coercer>> adapted = pairedArgs2.stream().map(SetPair::findEquivalenceCoercer).collect(Collectors.toList());
            if (!this.any(adapted, Optional::isPresent)) continue;
            coerced.add(CoercingFunctionWrapper.wrap(alternative2, adapted));
        }
        if (coerced.size() > 0) {
            log.debug("{} alternatives had coercible equivalents, recursively checking these...", (Object)coerced.size());
            RiskscapeFunction found = this.searchForBestAlternative(typeSet, coerced, givenTypes);
            if (found != null) {
                return found;
            }
        }
        log.debug("... no equivalents could be found, last strategy is to try with nulls striped from given...");
        ArrayList<RiskscapeFunction> nullSafes = new ArrayList<RiskscapeFunction>(alternatives.size());
        for (Pair pair : functionsAndPairedArgs) {
            RiskscapeFunction alternative3 = (RiskscapeFunction)pair.getLeft();
            List pairedArgs3 = (List)pair.getRight();
            if (!this.any(pairedArgs3, SetPair::isOnlyGivenNullable)) continue;
            nullSafes.add(NullSafeFunction.wrap((RiskscapeFunction)alternative3));
        }
        if (nullSafes.size() > 0) {
            log.debug("...{} alternatives have possible null-safe version, trying these...");
            return this.searchForBestAlternative(typeSet, nullSafes, givenTypes);
        }
        log.debug("...No null safe alternatives found.");
        return null;
    }

    private RiskscapeFunction adaptFunction1(TypeSet typeSet, RiskscapeFunction rf, List<Type> givenTypes) {
        return this.searchForBestAlternative(typeSet, Collections.singletonList(rf), givenTypes);
    }

    private List<SetPair> zipArgTypes(TypeSet typeSet, List<Type> givenTypes, List<Type> receiverTypes) {
        Iterator<Type> given = givenTypes.iterator();
        Iterator<Type> received = receiverTypes.iterator();
        ArrayList<SetPair> deltas = new ArrayList<SetPair>(Math.min(givenTypes.size(), receiverTypes.size()));
        while (given.hasNext() || received.hasNext()) {
            deltas.add(SetPair.from(typeSet, given, received));
        }
        return deltas;
    }

    private RiskscapeFunction normalizeReturnType(RealizationContext context, FunctionCall fc, RiskscapeFunction rf) {
        Struct normalized;
        Struct returnTypeStruct = rf.getReturnType().findAllowNull(Struct.class).orElse(null);
        if (returnTypeStruct != null && (normalized = context.normalizeStruct(returnTypeStruct)) != returnTypeStruct) {
            log.info("function {} ({}) returned a struct which could not be normalized.  RiskscapeFunction implementations should normalize any struct return types to avoid possible struct member owner errors", (Object)fc.getIdentifier(), (Object)rf);
        }
        return rf;
    }

    @Generated
    public DefaultFunctionResolver() {
    }

    private /* synthetic */ RiskscapeFunction lambda$adaptFunction$3(IdentifiedFunction targetFunction, RiskscapeFunction adapted, RiskscapeFunction rz) {
        return this.rewrap((RiskscapeFunction)targetFunction, rz, adapted);
    }

    public static class SetPair {
        final TypeSet typeSet;
        final Type given;
        final Type receiver;

        public SetPair(TypeSet typeSet, Type given, Type receiver) {
            this.typeSet = typeSet;
            this.given = given;
            this.receiver = receiver;
        }

        private static Type pick(Iterator<Type> types) {
            if (types.hasNext()) {
                return types.next();
            }
            return Types.NOTHING;
        }

        public static SetPair from(TypeSet typeSet, Iterator<Type> given, Iterator<Type> receiver) {
            return new SetPair(typeSet, SetPair.pick(given), SetPair.pick(receiver));
        }

        public static SetPair from(TypeSet typeSet, Type given, Type receiver) {
            return new SetPair(typeSet, given, receiver);
        }

        public boolean isOnlyGivenNullable() {
            return this.isGivenNullable() && !this.isReceiverNullable();
        }

        public boolean isGivenNullable() {
            return Nullable.is((Type)this.given);
        }

        public boolean isReceiverNullable() {
            return Nullable.is((Type)this.receiver);
        }

        public boolean isAssignable() {
            return this.typeSet.isAssignable(this.given, this.receiver);
        }

        public String toString() {
            return String.format("ArgPair(given=%s, receiver=%s)", this.given, this.receiver);
        }

        public Optional<Coercer> findEquivalenceCoercer() {
            return this.isAssignable() ? Optional.empty() : this.typeSet.findEquivalenceCoercer(this.given, this.receiver);
        }

        public Variance testVariance() {
            return this.typeSet.testVariance(this.given, this.receiver);
        }

        @Generated
        public Type getGiven() {
            return this.given;
        }

        @Generated
        public Type getReceiver() {
            return this.receiver;
        }
    }
}

