/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import com.google.common.collect.Streams;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import nz.org.riskscape.config.Config;
import nz.org.riskscape.config.ini.IniConfig;
import nz.org.riskscape.config.ini4j.Ini4jConfig;
import nz.org.riskscape.engine.BuildInfo;
import nz.org.riskscape.engine.DefaultDiagnostics;
import nz.org.riskscape.engine.DefaultIdentifiedLocator;
import nz.org.riskscape.engine.DefaultProject;
import nz.org.riskscape.engine.DefaultProjectBuilder;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.MemoryMonitoring;
import nz.org.riskscape.engine.ObjectAlreadyExistsException;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.bind.ParameterBinder;
import nz.org.riskscape.engine.data.BookmarkResolver;
import nz.org.riskscape.engine.data.DefaultBookmarkResolvers;
import nz.org.riskscape.engine.filter.FilterFactory;
import nz.org.riskscape.engine.function.FunctionFramework;
import nz.org.riskscape.engine.i18n.Messages;
import nz.org.riskscape.engine.io.DiskStorage;
import nz.org.riskscape.engine.io.TupleStorage;
import nz.org.riskscape.engine.model.ModelFramework;
import nz.org.riskscape.engine.output.DefaultPipelineOutputStores;
import nz.org.riskscape.engine.output.Format;
import nz.org.riskscape.engine.output.PipelineOutputStores;
import nz.org.riskscape.engine.pipeline.PipelineExecutor;
import nz.org.riskscape.engine.pipeline.PipelineSteps;
import nz.org.riskscape.engine.plugin.ExtensionPoints;
import nz.org.riskscape.engine.plugin.Plugin;
import nz.org.riskscape.engine.plugin.PluginFeature;
import nz.org.riskscape.engine.resource.DefaultResourceFactory;
import nz.org.riskscape.engine.resource.ResourceFactory;
import nz.org.riskscape.engine.sched.SchedulerBasedExecutor;
import nz.org.riskscape.engine.types.TypeRegistry;
import nz.org.riskscape.engine.util.FileUtils;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.ResultOrProblems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEngine
extends DefaultIdentifiedLocator
implements Engine.Writeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEngine.class);
    public static final String BETA_PLUGIN_ID = "beta";
    private final List<Object> manuallyRegisteredFeatures = new LinkedList<Object>();
    private final DefaultBookmarkResolvers bookmarkResolvers = this.put(new DefaultBookmarkResolvers());
    private final IdentifiedCollection<ParameterBinder> binders = this.put(new IdentifiedCollection.Base(ParameterBinder.class));
    private final IdentifiedCollection<Format> formats = this.put(new IdentifiedCollection.Base(Format.class));
    private FilterFactory filterFactory = new FilterFactory();
    private Messages messages;
    private final DefaultDiagnostics diagnostics = new DefaultDiagnostics();
    private MemoryMonitoring memoryPressureGauge = this.createMemoryPressureGauge();
    private TupleStorage tupleStorage = new DiskStorage(this.diagnostics.counter("disk-storage"));
    private ProblemSink problemSink = ProblemSink.DEVNULL;
    private ResourceFactory resourceFactory = new DefaultResourceFactory();
    private final PipelineSteps pipelineSteps = this.put(new PipelineSteps());
    private final TypeRegistry typeRegistry = this.put(new TypeRegistry());
    private PipelineExecutor pipelineExecutor;
    private final PipelineExecutor childPipelineExecutor = this.pipelineExecutor = new SchedulerBasedExecutor((Engine)this);
    private final BuildInfo buildInfo;
    private final List<Plugin> plugins;
    private final ExtensionPoints extensionPoints;
    private final Map<String, List<String>> settings;
    private final Path userHomeDirectory;
    private final Path tempDirectory;
    private final IdentifiedCollection<ModelFramework> modelFrameworks = this.put(new IdentifiedCollection.Base(ModelFramework.class));
    private final PipelineOutputStores pipelineOutputStores = this.put(new DefaultPipelineOutputStores());
    private final IdentifiedCollection<FunctionFramework> functionFrameworks = new IdentifiedCollection.Base(FunctionFramework.class);

    private static Path getFallbackHomeDir() {
        log.warn("No home directory given, falling back to pwd - this should not happen outside of test environments");
        return Paths.get(".", new String[0]);
    }

    public DefaultEngine() {
        this(BuildInfo.UNKNOWN, Collections.emptyList(), new ExtensionPoints(), Collections.emptyMap());
    }

    public DefaultEngine(BuildInfo buildInfo, List<Plugin> plugins, ExtensionPoints extensionPoints, Map<String, List<String>> settings) {
        this(buildInfo, plugins, extensionPoints, settings, DefaultEngine.getFallbackHomeDir());
    }

    public DefaultEngine(BuildInfo buildInfo, List<Plugin> plugins, ExtensionPoints extensionPoints, Map<String, List<String>> settings, Path userHomeDirectory) {
        this.buildInfo = buildInfo;
        this.plugins = plugins;
        this.extensionPoints = extensionPoints;
        this.settings = settings;
        this.userHomeDirectory = userHomeDirectory;
        try {
            this.tempDirectory = Files.createTempDirectory("rs-engine-", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FilterFactory getFilterFactory() {
        return this.filterFactory;
    }

    public void add(ParameterBinder binder) {
        this.binders.add((Identified)binder);
    }

    public void add(BookmarkResolver bookmarkResolver) {
        this.bookmarkResolvers.add((Identified)bookmarkResolver);
    }

    private MemoryMonitoring createMemoryPressureGauge() {
        MemoryMonitoring gauge = new MemoryMonitoring();
        this.diagnostics.getMetricRegistry().register("post-gc-heap-pressure", gauge.getPostFullGCHeapFreeLevel());
        this.diagnostics.getMetricRegistry().register("current-heap-pressure", gauge.getCurrentHeapFreeLevel());
        return gauge;
    }

    public <T> List<T> getFeaturesOfType(Class<T> featureClass) {
        if (PluginFeature.class.isAssignableFrom(featureClass)) {
            return this.getExtensionPoints().getFeaturesOfType(featureClass);
        }
        Stream<Object> fromPlugins = this.plugins.stream().map(p -> p.supportsFeature(featureClass)).filter(Optional::isPresent).map(Optional::get);
        Stream<Object> manuallyRegistered = this.manuallyRegisteredFeatures.stream().filter(f -> featureClass.isInstance(f)).map(f -> featureClass.cast(f));
        return Streams.concat((Stream[])new Stream[]{fromPlugins, manuallyRegistered}).collect(Collectors.toList());
    }

    public void addFeature(Object implementation) {
        this.manuallyRegisteredFeatures.add(implementation);
    }

    public boolean isBetaPluginEnabled() {
        return this.getPlugins().stream().anyMatch(plugin -> plugin.getId().equals(BETA_PLUGIN_ID));
    }

    public void setProblemSink(ProblemSink sink) {
        this.problemSink = sink;
        this.diagnostics.setNotificationSink(sink);
    }

    public Project emptyProject() {
        return (Project)this.buildProject(Config.EMPTY, (Problem problems) -> {}).get();
    }

    public ResultOrProblems<Project> buildProject(URI location, Consumer<Problem> problems) {
        boolean useLegacyParser;
        Object loadedConfig = location == EMPTY_PROJECT_LOCATION ? ResultOrProblems.of((Object)Config.empty((URI)Paths.get("", new String[0]).toUri())) : ((useLegacyParser = this.getSetting("engine.use-legacy-ini").equals(List.of("true"))) ? Ini4jConfig.load(location, this.getResourceFactory()) : IniConfig.load(location, this.getResourceFactory()));
        return loadedConfig.drainWarnings(problems).flatMap((config, iniProblems) -> this.buildProject((Config)config, problems));
    }

    public void close() {
        try {
            if (Files.exists(this.tempDirectory, new LinkOption[0])) {
                FileUtils.removeDirectory((Path)this.tempDirectory);
            }
        }
        catch (IOException e) {
            log.warn("could not delete engine temporary directory", (Throwable)e);
        }
    }

    private ResultOrProblems<Project> buildProject(Config config, Consumer<Problem> problems) {
        ResultOrProblems<Project> result;
        DefaultProject project = new DefaultProject((Engine)this, config);
        DefaultProjectBuilder builder = new DefaultProjectBuilder();
        try {
            result = builder.init(project);
        }
        catch (ObjectAlreadyExistsException ex) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ex.getProblem()});
        }
        result.getProblems().forEach(problems);
        return ResultOrProblems.of((Object)project);
    }

    public List<String> getSetting(String settingsKey) {
        return this.settings.getOrDefault(settingsKey, Collections.emptyList());
    }

    @Generated
    public DefaultBookmarkResolvers getBookmarkResolvers() {
        return this.bookmarkResolvers;
    }

    @Generated
    public IdentifiedCollection<ParameterBinder> getBinders() {
        return this.binders;
    }

    @Generated
    public IdentifiedCollection<Format> getFormats() {
        return this.formats;
    }

    @Generated
    public Messages getMessages() {
        return this.messages;
    }

    @Generated
    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    @Generated
    public DefaultDiagnostics getDiagnostics() {
        return this.diagnostics;
    }

    @Generated
    public MemoryMonitoring getMemoryPressureGauge() {
        return this.memoryPressureGauge;
    }

    @Generated
    public TupleStorage getTupleStorage() {
        return this.tupleStorage;
    }

    @Generated
    public ProblemSink getProblemSink() {
        return this.problemSink;
    }

    @Generated
    public ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    @Generated
    public void setResourceFactory(ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    @Generated
    public PipelineSteps getPipelineSteps() {
        return this.pipelineSteps;
    }

    @Generated
    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    @Generated
    public PipelineExecutor getPipelineExecutor() {
        return this.pipelineExecutor;
    }

    @Generated
    public void setPipelineExecutor(PipelineExecutor pipelineExecutor) {
        this.pipelineExecutor = pipelineExecutor;
    }

    @Generated
    public PipelineExecutor getChildPipelineExecutor() {
        return this.childPipelineExecutor;
    }

    @Generated
    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    @Generated
    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    @Generated
    public ExtensionPoints getExtensionPoints() {
        return this.extensionPoints;
    }

    @Generated
    public Path getUserHomeDirectory() {
        return this.userHomeDirectory;
    }

    @Generated
    public Path getTempDirectory() {
        return this.tempDirectory;
    }

    @Generated
    public IdentifiedCollection<ModelFramework> getModelFrameworks() {
        return this.modelFrameworks;
    }

    @Generated
    public PipelineOutputStores getPipelineOutputStores() {
        return this.pipelineOutputStores;
    }

    @Generated
    public IdentifiedCollection<FunctionFramework> getFunctionFrameworks() {
        return this.functionFrameworks;
    }
}

