/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.eqrule.Coercer;

public class CoercingFunctionWrapper
implements RiskscapeFunction {
    private final List<Optional<Coercer>> coercers;
    private final RiskscapeFunction wrapped;
    private final List<Type> argumentTypes;

    public static RiskscapeFunction wrap(RiskscapeFunction wrapped, List<Optional<Coercer>> coercers) {
        if (wrapped.getArgumentTypes().size() > coercers.size()) {
            throw new IllegalArgumentException("There must be a coercer for every argument type");
        }
        ArrayList<Type> argumentTypes = new ArrayList<Type>(coercers.size());
        for (int i = 0; i < wrapped.getArgumentTypes().size(); ++i) {
            argumentTypes.add(coercers.get(i).map(Coercer::getSourceType).orElse((Type)wrapped.getArgumentTypes().get(i)));
        }
        return new CoercingFunctionWrapper(coercers, wrapped, argumentTypes);
    }

    public Object call(List<Object> args) {
        ArrayList<Object> coerced = new ArrayList<Object>(args.size());
        for (int i = 0; i < args.size(); ++i) {
            Object argValue = args.get(i);
            coerced.add(this.coercers.get(i).map(c -> c.apply(argValue)).orElse(argValue));
        }
        return this.wrapped.call(coerced);
    }

    public Type getReturnType() {
        return this.wrapped.getReturnType();
    }

    public void close() {
        this.wrapped.close();
    }

    public String toString() {
        return String.format("Coercing(%s)", this.wrapped);
    }

    @Generated
    private CoercingFunctionWrapper(List<Optional<Coercer>> coercers, RiskscapeFunction wrapped, List<Type> argumentTypes) {
        this.coercers = coercers;
        this.wrapped = wrapped;
        this.argumentTypes = argumentTypes;
    }

    @Generated
    public List<Optional<Coercer>> getCoercers() {
        return this.coercers;
    }

    @Generated
    public RiskscapeFunction getWrapped() {
        return this.wrapped;
    }

    @Generated
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }
}

