/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.config.ini4j;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import lombok.Generated;
import nz.org.riskscape.config.ConfigSection;
import nz.org.riskscape.config.ConfigString;
import nz.org.riskscape.config.ini4j.Ini4jConfigConstants;
import org.ini4j.Profile;

public class Ini4jConfigSection
extends ConfigSection
implements Ini4jConfigConstants {
    private final Profile.Section section;
    private Map<ConfigString, List<ConfigString>> multiMap;

    public Ini4jConfigSection(Profile.Section section, URI location, String name) {
        super(location, name);
        this.section = section;
        this.multiMap = this.buildConfigMap();
    }

    private Map<ConfigString, List<ConfigString>> buildConfigMap() {
        LinkedHashMap<ConfigString, List<ConfigString>> newMultiMap = new LinkedHashMap<ConfigString, List<ConfigString>>();
        URI location = this.getLocation();
        for (String key : this.section.keySet()) {
            List<ConfigString> all = this.section.getAll((Object)key).stream().filter(Predicate.not(String::isBlank)).map(str -> ConfigString.wrap((URI)location, (CharSequence)str)).toList();
            newMultiMap.put(ConfigString.wrap((URI)location, (CharSequence)key), all);
        }
        return newMultiMap;
    }

    public Map<ConfigString, List<ConfigString>> toConfigMap() {
        return this.multiMap;
    }

    public String toString() {
        return String.format("IniSection(name=%s keys=%s source=%s)", this.section.getName(), this.section.keySet(), this.getLocation());
    }

    @Generated
    public Profile.Section getSection() {
        return this.section;
    }
}

