/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.config.ini4j;

import com.google.common.base.Strings;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.config.Config;
import nz.org.riskscape.config.ConfigProblems;
import nz.org.riskscape.config.ConfigSection;
import nz.org.riskscape.config.ini4j.Ini4jConfigConstants;
import nz.org.riskscape.config.ini4j.Ini4jConfigSection;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.ini.IniParser;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.resource.ResourceFactory;
import nz.org.riskscape.engine.resource.ResourceProblems;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ini4jConfig
implements Config,
Ini4jConfigConstants {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Ini4jConfig.class);
    private final URI rootLocation;
    private final LinkedHashMap<String, Ini4jConfigSection> sections = new LinkedHashMap();

    public static ResultOrProblems<Ini4jConfig> load(URI base, ResourceFactory factory) {
        Builder builder = new Builder(factory);
        try {
            if ("file".equals(base.getScheme())) {
                builder.loadFromFiles(base);
            } else {
                builder.loadInifile(base, null);
            }
        }
        catch (ProblemException e) {
            return e.toResult();
        }
        catch (RiskscapeException e) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)e)});
        }
        if (Problem.hasErrors(builder.problems)) {
            return ResultOrProblems.failed(builder.problems);
        }
        return ResultOrProblems.of((Object)builder.building, builder.problems);
    }

    public List<ConfigSection> getAll() {
        return this.sections.values().stream().collect(Collectors.toList());
    }

    public Optional<ConfigSection> getSection(String name) {
        return Optional.ofNullable((ConfigSection)this.sections.get(name));
    }

    public List<Problem> add(Ini ini, Resource location) {
        return this.add(ini, location, "");
    }

    public List<Problem> add(Ini ini, Resource location, String implicitPrefix) {
        boolean wasFirst = this.sections.isEmpty();
        LinkedList<Problem> problems = new LinkedList<Problem>();
        for (String sectionName : ini.keySet()) {
            List lookedUpSections = ini.getAll((Object)sectionName);
            if (lookedUpSections == null) continue;
            for (Profile.Section section : lookedUpSections) {
                Object nameToUse = sectionName.equals("project") ? "project " + String.valueOf(location.getLocation()) : (implicitPrefix != null && !sectionName.startsWith(implicitPrefix) ? implicitPrefix + sectionName : sectionName);
                Ini4jConfigSection newSection = new Ini4jConfigSection(section, location.getLocation(), (String)nameToUse);
                Ini4jConfigSection existing = this.sections.get(nameToUse);
                if (existing != null) {
                    problems.add(ConfigProblems.get().duplicateSection(newSection.getName(), existing.getLocation(), newSection.getLocation()));
                    continue;
                }
                if (sectionName.equals("project") && wasFirst) {
                    this.sections.put("project", new Ini4jConfigSection(section, location.getLocation(), "project"));
                    continue;
                }
                this.sections.put(newSection.getName(), newSection);
            }
        }
        return problems;
    }

    @Generated
    public Ini4jConfig(URI rootLocation) {
        this.rootLocation = rootLocation;
    }

    @Generated
    public URI getRootLocation() {
        return this.rootLocation;
    }

    static class Builder
    implements Ini4jConfigConstants {
        final ResourceFactory factory;
        Ini4jConfig building;
        final List<Problem> problems = new LinkedList<Problem>();

        Ini loadInifile(URI location, String prefix) {
            Resource resource = this.factory.load(location);
            try {
                Ini ini = IniParser.parse(resource.getContentStream());
                if (this.building == null) {
                    this.building = new Ini4jConfig(location);
                }
                Profile.Section projectSection = null;
                List projectSections = ini.getAll((Object)"project");
                if (projectSections != null) {
                    for (int i = 0; i < projectSections.size(); ++i) {
                        if (i == 0) {
                            projectSection = (Profile.Section)projectSections.get(i);
                            continue;
                        }
                        this.problems.add(ConfigProblems.get().duplicateSection("project", location, location));
                    }
                }
                this.problems.addAll(this.building.add(ini, resource, (String)(Strings.isNullOrEmpty((String)prefix) ? "" : prefix + " ")));
                if (projectSection != null) {
                    this.addImports(projectSection, location);
                }
                return ini;
            }
            catch (RiskscapeIOException e) {
                throw new RiskscapeException((Problems)Problems.foundWith(Config.class, (String)location.toString(), (Problem[])new Problem[]{Problems.caught((Throwable)e)}));
            }
        }

        private void addImports(Profile.Section section, URI uri) {
            List imports;
            if (section != null) {
                for (Map.Entry entry : Ini4jConfigSection.TYPE_PREFIXES.entrySet()) {
                    String importType = (String)entry.getKey();
                    List imports2 = section.getAll((Object)importType);
                    if (imports2 == null) continue;
                    for (String importThis : imports2) {
                        if (!importThis.endsWith(".ini")) continue;
                        URI importLocation = uri.resolve(importThis);
                        this.loadInifile(importLocation, (String)entry.getValue());
                    }
                }
            }
            if ((imports = section.getAll((Object)"import")) != null) {
                for (String untypedImport : imports) {
                    URI importLocation = uri.resolve(untypedImport);
                    this.loadInifile(importLocation, null);
                }
            }
        }

        void loadFromFiles(URI base) throws ProblemException {
            URI projectIniLocation;
            File dir;
            File baseFile = Paths.get(base).toFile();
            if (!baseFile.exists()) {
                throw new ProblemException((Problems)ResourceProblems.get().notFound(base, new Problem[0]));
            }
            if (baseFile.isDirectory()) {
                dir = baseFile;
                projectIniLocation = base.resolve("project.ini");
            } else {
                dir = baseFile.getParentFile();
                projectIniLocation = base;
            }
            this.loadInifile(projectIniLocation, null);
            boolean autoimport = "true".equals(this.building.getSection("project").flatMap(section -> section.getOne("auto-import")).map(ror -> (String)ror.orElse(null)).orElse("false"));
            if (autoimport) {
                this.addRecursively(dir, 0);
            }
        }

        void addRecursively(File dir, int rCount) {
            File[] iniFiles;
            if (!dir.isDirectory() || !dir.canRead()) {
                return;
            }
            for (File inifile : iniFiles = dir.listFiles((d, name) -> name.endsWith(".ini"))) {
                String prefix = this.getWellKnownTypePrefix(inifile.getName());
                if (prefix == null) continue;
                this.loadInifile(inifile.toURI(), prefix);
            }
            if (rCount == 64) {
                log.warn("Recursion limit reached, not descending in to directories below {}", (Object)dir);
                return;
            }
            ++rCount;
            for (File subdir : dir.listFiles(file -> file.isDirectory())) {
                this.addRecursively(subdir, rCount);
            }
        }

        @Generated
        public Builder(ResourceFactory factory) {
            this.factory = factory;
        }
    }
}

