/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.config.ini;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.config.ConfigSection;
import nz.org.riskscape.config.ConfigString;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.ini.KeyValue;
import nz.org.riskscape.ini.Section;

public class IniConfigSection
extends ConfigSection {
    private final Section section;
    private final Map<ConfigString, List<ConfigString>> configMap;

    public IniConfigSection(URI location, String name, Section section) {
        super(section.getHeaderToken().getLocation().addToUri(location), name);
        this.section = section;
        this.configMap = section.getMembers().stream().collect(Collectors.toMap(kv -> ConfigString.wrap((URI)location, (CharSequence)kv.getKey()), kv -> kv.isBlank() ? List.of() : List.of(this.encodeValue((KeyValue)kv)), (a, b) -> {
            ArrayList list = new ArrayList(a.size() + b.size());
            list.addAll(a);
            list.addAll(b);
            return list;
        }, LinkedHashMap::new));
    }

    public Map<ConfigString, List<ConfigString>> toConfigMap() {
        return this.configMap;
    }

    private ConfigString encodeValue(KeyValue keyValue) {
        final Token token = keyValue.getValueToken();
        return new ConfigString.Wrapper(keyValue.getValue()){

            public URI getLocation() {
                return token.getLocation().addToUri(IniConfigSection.this.getLocation());
            }
        };
    }

    @Generated
    public Section getSection() {
        return this.section;
    }
}

