/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.config.ini;

import com.google.common.base.Strings;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.config.Config;
import nz.org.riskscape.config.ConfigProblems;
import nz.org.riskscape.config.ConfigSection;
import nz.org.riskscape.config.ini.IniConfigSection;
import nz.org.riskscape.config.ini4j.Ini4jConfigConstants;
import nz.org.riskscape.config.ini4j.Ini4jConfigSection;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.resource.ResourceFactory;
import nz.org.riskscape.engine.resource.ResourceProblems;
import nz.org.riskscape.ini.IniFile;
import nz.org.riskscape.ini.IniParser2;
import nz.org.riskscape.ini.Section;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniConfig
implements Config,
Ini4jConfigConstants {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IniConfig.class);
    private static final String FILE_PROTO = "file";
    private final URI rootLocation;
    private final LinkedHashMap<String, IniConfigSection> sections = new LinkedHashMap();

    public static IniConfig fromIniFile(URI location, IniFile inifile) {
        return IniConfig.fromIniFile(location, inifile, ProblemSink.DEVNULL);
    }

    public static IniConfig fromIniFile(URI location, IniFile inifile, ProblemSink problemSink) {
        IniConfig config = new IniConfig(location);
        config.add(inifile, location).stream().forEach(problem -> problemSink.accept(problem));
        return config;
    }

    public static ResultOrProblems<IniConfig> load(URI base, ResourceFactory factory) {
        Builder builder = new Builder(factory, new IniConfig(base));
        try {
            if (FILE_PROTO.equals(base.getScheme())) {
                builder.loadFromFiles(base);
            } else {
                builder.loadInifile(base, null);
            }
        }
        catch (ProblemException e) {
            return e.toResult();
        }
        catch (RiskscapeException e) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)e)});
        }
        if (Problem.hasErrors(builder.problems)) {
            return ResultOrProblems.failed(builder.problems);
        }
        return ResultOrProblems.of((Object)builder.building, builder.problems);
    }

    public List<ConfigSection> getAll() {
        return this.sections.values().stream().collect(Collectors.toList());
    }

    public Optional<ConfigSection> getSection(String name) {
        return Optional.ofNullable((ConfigSection)this.sections.get(name));
    }

    public List<Problem> add(IniFile ini, URI location) {
        return this.add(ini, location, "");
    }

    public List<Problem> add(IniFile ini, URI location, String implicitPrefix) {
        boolean wasFirst = this.sections.isEmpty();
        LinkedList<Problem> problems = new LinkedList<Problem>();
        for (Section section : ini.getSections()) {
            Object nameToUse = section.getName().equals("project") ? "project " + String.valueOf(location) : (implicitPrefix != null && !section.getName().startsWith(implicitPrefix) ? implicitPrefix + section.getName() : section.getName());
            IniConfigSection newSection = new IniConfigSection(location, (String)nameToUse, section);
            IniConfigSection existing = this.sections.get(nameToUse);
            if (existing != null) {
                problems.add(ConfigProblems.get().duplicateSection(newSection.getName(), existing.getLocation(), newSection.getLocation()));
                continue;
            }
            log.debug("Adding section {}", (Object)newSection.getName());
            if (section.getName().equals("project") && wasFirst) {
                this.sections.put("project", new IniConfigSection(location, "project", section));
                continue;
            }
            this.sections.put(newSection.getName(), newSection);
        }
        return problems;
    }

    @Generated
    public IniConfig(URI rootLocation) {
        this.rootLocation = rootLocation;
    }

    @Generated
    public URI getRootLocation() {
        return this.rootLocation;
    }

    static class Builder
    implements Ini4jConfigConstants {
        final ResourceFactory factory;
        final IniConfig building;
        final List<Problem> problems = new LinkedList<Problem>();

        IniFile loadInifile(URI location, String prefix) {
            Resource resource = this.factory.load(location);
            try {
                IniParser2 parser = new IniParser2();
                IniFile root = parser.parse(resource.getContentAsString());
                List<Section> projectSections = root.getSections().stream().filter(s -> s.getName().equals("project")).toList();
                Section projectSection = null;
                if (projectSections != null) {
                    for (int i = 0; i < projectSections.size(); ++i) {
                        if (i == 0) {
                            projectSection = projectSections.get(i);
                            continue;
                        }
                        this.problems.add(ConfigProblems.get().duplicateSection("project", location, location));
                    }
                }
                this.problems.addAll(this.building.add(root, resource.getLocation(), (String)(Strings.isNullOrEmpty((String)prefix) ? "" : prefix + " ")));
                if (projectSection != null) {
                    this.addImports(projectSection, location);
                }
                return root;
            }
            catch (RuntimeException e) {
                throw new RiskscapeException((Problems)Problems.foundWith(Config.class, (String)location.toString(), (Problem[])new Problem[]{Problems.caught((Throwable)e)}));
            }
        }

        private void addImports(Section section, URI uri) {
            List imports;
            if (section != null) {
                for (Map.Entry entry : Ini4jConfigSection.TYPE_PREFIXES.entrySet()) {
                    String importType = (String)entry.getKey();
                    List imports2 = section.getAll(importType);
                    if (imports2 == null) continue;
                    for (String importThis : imports2) {
                        if (!importThis.endsWith(".ini")) continue;
                        URI importLocation = uri.resolve(importThis);
                        log.debug("Processing import {}", (Object)importLocation);
                        this.loadInifile(importLocation, (String)entry.getValue());
                    }
                }
            }
            if ((imports = section.getAll("import")) != null) {
                for (String untypedImport : imports) {
                    URI importLocation = uri.resolve(untypedImport);
                    log.debug("Processing import {}", (Object)importLocation);
                    this.loadInifile(importLocation, null);
                }
            }
        }

        void loadFromFiles(URI base) throws ProblemException {
            URI projectIniLocation;
            File dir;
            File baseFile = Paths.get(base).toFile();
            if (!baseFile.exists()) {
                throw new ProblemException((Problems)ResourceProblems.get().notFound(base, new Problem[0]));
            }
            if (baseFile.isDirectory()) {
                dir = baseFile;
                projectIniLocation = base.resolve("project.ini");
            } else {
                dir = baseFile.getParentFile();
                projectIniLocation = base;
            }
            this.loadInifile(projectIniLocation, null);
            boolean autoimport = "true".equals(this.building.getSection("project").flatMap(section -> section.getOne("auto-import")).map(ror -> (String)ror.orElse(null)).orElse("false"));
            if (autoimport) {
                this.addRecursively(dir, 0);
            }
        }

        void addRecursively(File dir, int rCount) {
            File[] iniFiles;
            if (!dir.isDirectory() || !dir.canRead()) {
                return;
            }
            for (File inifile : iniFiles = dir.listFiles((d, name) -> name.endsWith(".ini"))) {
                String prefix = this.getWellKnownTypePrefix(inifile.getName());
                if (prefix == null) continue;
                this.loadInifile(inifile.toURI(), prefix);
            }
            if (rCount == 64) {
                log.warn("Recursion limit reached, not descending in to directories below {}", (Object)dir);
                return;
            }
            ++rCount;
            for (File subdir : dir.listFiles(file -> file.isDirectory())) {
                this.addRecursively(subdir, rCount);
            }
        }

        @Generated
        public Builder(ResourceFactory factory, IniConfig building) {
            this.factory = factory;
            this.building = building;
        }
    }
}

