/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.config;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import nz.org.riskscape.config.ConfigSection;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.resource.ResourceLoadingException;
import nz.org.riskscape.engine.resource.UriHelper;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class ConfigUtils {
    public static Stream<Resource> getResources(Project project, Consumer<Problem> problemSink, Predicate<ConfigSection> fromSections, String key) {
        return project.getConfig().getAll().stream().filter(fromSections).flatMap(cs -> {
            List values = cs.getAll(key);
            return (values == null ? Collections.emptyList() : values).stream().map(str -> Pair.of((Object)cs, (Object)UriHelper.uriFromLocation((String)str, (URI)cs.getLocation())));
        }).flatMap(configSectionAnduriOr -> (Stream)((ResultOrProblems)configSectionAnduriOr.getRight()).ifElseReturn(uri -> {
            try {
                Resource resource = project.getEngine().getResourceFactory().load(uri);
                return Collections.singletonList(resource).stream();
            }
            catch (ResourceLoadingException rex) {
                problemSink.accept(Problems.foundWith((Object)configSectionAnduriOr.getLeft(), (Problems)rex.getProblem()));
                return Collections.emptyList().stream();
            }
        }, probs -> {
            problemSink.accept(Problems.foundWith((Object)configSectionAnduriOr.getLeft(), (List)probs));
            return Collections.emptyList().stream();
        }));
    }
}

