/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.config;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.bind.ParamProblems;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.bind.impl.BooleanBinder;
import nz.org.riskscape.engine.bind.impl.NumberBinder;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class BootstrapIniSettings {
    public static final BootstrapIniSettings NONE = new BootstrapIniSettings(Collections.emptyMap(), ProblemSink.DEVNULL);
    private final Map<String, List<String>> unbound;
    private final ProblemSink sink;

    public <T extends Number> T getOrDefault(String parameterName, T defaultValue) {
        return this.getOrDefault(parameterName, defaultValue, v -> new NumberBinder().bindValue(v, defaultValue.getClass()));
    }

    public boolean getOrDefault(String parameterName, boolean defaultValue) {
        return this.getOrDefault(parameterName, defaultValue, v -> new BooleanBinder().bindValue(v));
    }

    private <T> T getOrDefault(String parameterName, T defaultValue, Function<Object, ResultOrProblems<T>> binder) {
        List values = this.unbound.getOrDefault(parameterName, Collections.emptyList());
        if (values.isEmpty()) {
            return defaultValue;
        }
        if (values.size() != 1) {
            this.sink.log(ParamProblems.get().wrongNumberGiven(parameterName, "1", values.size()).withSeverity(Problem.Severity.WARNING));
        }
        ResultOrProblems<T> bound = binder.apply(values.get(0));
        bound.getProblems().forEach(p -> this.sink.log(Problems.foundWith(Parameter.class, (String)parameterName, (Problem[])new Problem[]{p.withSeverity(Problem.Severity.WARNING)})));
        return (T)(bound.hasErrors() ? defaultValue : bound.getWithProblemsIgnored());
    }

    @Generated
    public BootstrapIniSettings(Map<String, List<String>> unbound, ProblemSink sink) {
        this.unbound = unbound;
        this.sink = sink;
    }

    @Generated
    public Map<String, List<String>> getUnbound() {
        return this.unbound;
    }
}

