/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.store.MaxFeaturesIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class MaxFeaturesFeatureCollection<T extends FeatureType, F extends Feature>
extends DecoratingFeatureCollection<T, F> {
    FeatureCollection<T, F> delegate;
    long max;

    public MaxFeaturesFeatureCollection(FeatureCollection<T, F> delegate, long max) {
        super(delegate);
        this.delegate = delegate;
        this.max = max;
    }

    public FeatureReader<T, F> reader() throws IOException {
        return new DelegateFeatureReader(this.getSchema(), this.features());
    }

    @Override
    public FeatureIterator<F> features() {
        return new MaxFeaturesIterator<F>(this.delegate.features(), this.max);
    }

    @Override
    public FeatureCollection<T, F> subCollection(Filter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FeatureCollection<T, F> sort(SortBy order) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return (int)Math.min((long)this.delegate.size(), this.max);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty() || this.max == 0L;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <O> O[] toArray(O[] a) {
        ArrayList<F> list = new ArrayList<F>();
        try (FeatureIterator<F> i = this.features();){
            while (i.hasNext()) {
                list.add(i.next());
            }
            O[] OArray = list.toArray(a);
            return OArray;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return DataUtilities.bounds(this);
    }
}

