/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.oq.sitecol;

import java.util.Iterator;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.relation.BaseRelation;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.hdf5.H5Dataset;
import nz.org.riskscape.oq.sitecol.Site;
import nz.org.riskscape.oq.sitecol.SitecolIterator;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.locationtech.jts.geom.GeometryFactory;

public class SitecolRelation
extends BaseRelation {
    private final H5Dataset sitecolDataset;
    private final GeometryFactory gf;

    private static Struct buildType(CoordinateReferenceSystem crs) {
        return Struct.of((String)"siteid", (Type)Types.INTEGER, (String)"location", (Type)Referenced.of((Type)Types.POINT, (CoordinateReferenceSystem)crs));
    }

    public SitecolRelation(H5Dataset sitecolDataset, CoordinateReferenceSystem crs, SRIDSet sridSet) {
        super(SitecolRelation.buildType(crs));
        this.sitecolDataset = sitecolDataset;
        this.gf = sridSet.getGeometryFactory(crs);
    }

    public SitecolRelation(BaseRelation.Fields fields, H5Dataset sitecolDataset, GeometryFactory gf) {
        super(fields);
        this.sitecolDataset = sitecolDataset;
        this.gf = gf;
    }

    public String getSourceInformation() {
        return this.sitecolDataset.toString();
    }

    protected TupleIterator rawIterator() {
        return TupleIterator.wrappedAndMapped((Iterator)new SitecolIterator(this.sitecolDataset, "lon", "lat"), this::siteToTuple);
    }

    private Tuple siteToTuple(Site site) {
        return Tuple.ofValues((Struct)this.getRawType(), (Object[])new Object[]{site.siteId, this.gf.createPoint(site.getCoordinate())});
    }

    protected BaseRelation clone(BaseRelation.Fields fields) {
        return new SitecolRelation(fields, this.sitecolDataset, this.gf);
    }
}

