/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.oq.sitecol;

import java.nio.ByteBuffer;
import java.util.Iterator;
import nz.org.riskscape.hdf5.H5CompoundMember;
import nz.org.riskscape.hdf5.H5Dataset;
import nz.org.riskscape.hdf5.cursor.H5FixedSizeCursor;
import nz.org.riskscape.hdf5.types.H5CompoundType;
import nz.org.riskscape.oq.sitecol.Site;

public class SitecolIterator
implements Iterator<Site> {
    private long index = 0L;
    private final H5FixedSizeCursor cursor;
    private H5CompoundType h5Type;
    private final int lonIndex;
    private final int latIndex;

    public SitecolIterator(H5Dataset dataset) {
        this(dataset, "lon", "lat");
    }

    public SitecolIterator(H5Dataset dataset, String lonName, String latName) {
        this.cursor = (H5FixedSizeCursor)dataset.openCursor();
        this.h5Type = (H5CompoundType)dataset.getDataType();
        this.lonIndex = this.h5Type.findIndex(lonName);
        this.latIndex = this.h5Type.findIndex(latName);
    }

    @Override
    public boolean hasNext() {
        return this.cursor.hasNext();
    }

    @Override
    public Site next() {
        ByteBuffer bb = this.cursor.getByteBuffer();
        Number latitude = (Number)this.cursor.peek((H5CompoundMember)this.h5Type.getMembers().get(this.latIndex));
        Number longitude = (Number)this.cursor.peek((H5CompoundMember)this.h5Type.getMembers().get(this.lonIndex));
        Site site = new Site(latitude.floatValue(), longitude.floatValue(), this.index);
        ++this.index;
        this.cursor.setCurrentIndex(this.index);
        return site;
    }
}

