/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.oq.gmf;

import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import nz.org.riskscape.hdf5.H5DataSpace;
import nz.org.riskscape.hdf5.H5Dataset;
import nz.org.riskscape.hdf5.types.H5Type;
import nz.org.riskscape.hdf5.types.H5VlenType;

public class SitecolGmfDataIndex {
    private final H5Dataset gmfdataIndices;
    private final long memspaceId;
    private final boolean vlen;
    private final H5DataSpace dataspace;

    public SitecolGmfDataIndex(H5Dataset gmfdataIndices) {
        this.gmfdataIndices = gmfdataIndices;
        this.memspaceId = H5.H5Screate_simple((int)1, (long[])new long[]{2L}, null);
        this.dataspace = gmfdataIndices.newDataSpace();
        this.vlen = gmfdataIndices.getDataType() instanceof H5VlenType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[][] lookupIndices(long siteid) {
        long[][] selection = new long[][]{{siteid, 0L}, {siteid, 1L}};
        H5DataSpace h5DataSpace = this.dataspace;
        synchronized (h5DataSpace) {
            H5.H5Sselect_elements((long)this.dataspace.getPointer(), (int)HDF5Constants.H5S_SELECT_SET, (int)2, (long[][])selection);
            if (this.vlen) {
                Object[] dataBytes = new Object[2];
                H5.H5DreadVL((long)this.gmfdataIndices.getPointer(), (long)this.gmfdataIndices.getDataType().getPointer(), (long)this.memspaceId, (long)this.dataspace.getPointer(), (long)HDF5Constants.H5P_DEFAULT, (Object[])dataBytes);
                long[] startLongs = this.readLongs((byte[])dataBytes[0]);
                long[] finishLongs = this.readLongs((byte[])dataBytes[1]);
                return new long[][]{startLongs, finishLongs};
            }
            int dataSize = (int)this.gmfdataIndices.getDataType().getDataSize();
            byte[] bytes = new byte[dataSize * 2];
            H5.H5Dread((long)this.gmfdataIndices.getPointer(), (long)this.gmfdataIndices.getDataType().getPointer(), (long)this.memspaceId, (long)this.dataspace.getPointer(), (long)HDF5Constants.H5P_DEFAULT, (byte[])bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.nativeOrder());
            long start = ((Number)this.gmfdataIndices.getDataType().read(buffer, 0)).longValue();
            long stop = ((Number)this.gmfdataIndices.getDataType().read(buffer, dataSize)).longValue();
            return new long[][]{{start}, {stop}};
        }
    }

    private long[] readLongs(byte[] bytes) {
        H5Type childType = ((H5VlenType)this.gmfdataIndices.getDataType()).getMemberType();
        int numElements = (int)((long)bytes.length / childType.getDataSize());
        long[] longs = new long[numElements];
        ByteBuffer wrapped = ByteBuffer.wrap(bytes);
        wrapped.order(ByteOrder.nativeOrder());
        int index = 0;
        for (int j = 0; j < bytes.length; j += (int)childType.getDataSize()) {
            Number read = (Number)childType.read(wrapped, j);
            longs[index++] = read.longValue();
        }
        return longs;
    }
}

