/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.oq.gmf;

import com.google.common.collect.Lists;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.lookup.LookupTable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.hdf5.H5Dataset;
import nz.org.riskscape.oq.gmf.GmfData;
import nz.org.riskscape.oq.gmf.GmfDataBySiteIdList;
import nz.org.riskscape.oq.gmf.SitecolGmfDataIndex;

public class GmfDataLookupBySite
implements LookupTable {
    private static final Struct VALUE_STRUCT = Struct.of((String)"eid", (Type)Types.INTEGER, (String)"gmv", (Type)Types.FLOATING);
    private final Type keyType = Types.INTEGER;
    private final Type valueType = RSList.create((Type)VALUE_STRUCT);
    private final SitecolGmfDataIndex index;
    private final H5Dataset gmfDataset;

    public Object lookup(Object key) {
        Long siteId = (Long)key;
        GmfDataBySiteIdList list = new GmfDataBySiteIdList((long)siteId, this.index, this.gmfDataset);
        return Lists.transform((List)list, this::gmfDataToTuple);
    }

    private Tuple gmfDataToTuple(GmfData gmfData) {
        return Tuple.ofValues((Struct)VALUE_STRUCT, (Object[])new Object[]{gmfData.eventId, (double)gmfData.gmv[0]});
    }

    @Generated
    public GmfDataLookupBySite(SitecolGmfDataIndex index, H5Dataset gmfDataset) {
        this.index = index;
        this.gmfDataset = gmfDataset;
    }

    @Generated
    public Type getKeyType() {
        return this.keyType;
    }

    @Generated
    public Type getValueType() {
        return this.valueType;
    }
}

