/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.oq.gmf;

import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.HashMap;
import lombok.Generated;
import nz.org.riskscape.hdf5.H5CompoundMember;
import nz.org.riskscape.hdf5.H5DataSpace;
import nz.org.riskscape.hdf5.H5Dataset;
import nz.org.riskscape.hdf5.types.H5ArrayType;
import nz.org.riskscape.hdf5.types.H5CompoundType;
import nz.org.riskscape.hdf5.types.H5IntegerType;
import nz.org.riskscape.oq.gmf.GmfData;
import nz.org.riskscape.oq.gmf.SitecolGmfDataIndex;

public class GmfDataBySiteIdList
extends AbstractList<GmfData> {
    private final long siteId;
    private final long[] startIndices;
    private final long[] endIndices;
    private final int size;
    private final H5Dataset gmfDataset;
    private final H5CompoundMember sidMember;
    private final H5CompoundMember eidMember;
    private final H5CompoundMember gmvMember;
    private final HashMap<Long, ByteBuffer> cachedBytes = new HashMap();

    public GmfDataBySiteIdList(long siteId, long[] startIndices, long[] endIndices, H5Dataset gmfDataset) {
        this.siteId = siteId;
        this.startIndices = startIndices;
        this.endIndices = endIndices;
        this.gmfDataset = gmfDataset;
        this.size = this.calculateSize();
        H5CompoundType type = (H5CompoundType)gmfDataset.getDataType();
        this.sidMember = type.findMember("sid");
        ((H5IntegerType)this.sidMember.type).setOpaqueUnsignedLongs(true);
        this.eidMember = type.findMember("eid");
        ((H5IntegerType)this.eidMember.type).setOpaqueUnsignedLongs(true);
        this.gmvMember = type.findMember("gmv");
    }

    public GmfDataBySiteIdList(long siteid, long[][] indices, H5Dataset gmfDataset) {
        this(siteid, indices[0], indices[1], gmfDataset);
    }

    public GmfDataBySiteIdList(long siteid, SitecolGmfDataIndex index, H5Dataset gmfDataset) {
        this(siteid, index.lookupIndices(siteid), gmfDataset);
    }

    private int calculateSize() {
        int total = 0;
        for (int i = 0; i < this.endIndices.length; ++i) {
            long start = this.startIndices[i];
            long end = this.endIndices[i];
            total = (int)((long)total + (end - start));
        }
        return total;
    }

    @Override
    public GmfData get(int index) {
        int total = 0;
        long start = -1L;
        long end = -1L;
        for (int i = 0; i < this.endIndices.length; ++i) {
            start = this.startIndices[i];
            end = this.endIndices[i];
            if (index >= total && (long)index < (long)total + (end - start)) break;
            total = (int)((long)total + (end - start));
        }
        ByteBuffer buffer = this.readFrom(start, end);
        int selectionOffset = index - total;
        int byteOffset = (int)(this.gmfDataset.getDataType().getDataSize() * (long)selectionOffset);
        long sid = ((Number)this.sidMember.read(buffer, byteOffset)).longValue();
        long eid = ((Number)this.eidMember.read(buffer, byteOffset)).longValue();
        float[] floats = ((H5ArrayType)this.gmvMember.type).readFloats(buffer, this.gmvMember.byteOffset + byteOffset);
        return new GmfData(eid, sid, floats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateCachedBytes() {
        if (this.cachedBytes.isEmpty()) {
            H5Dataset h5Dataset = this.gmfDataset;
            synchronized (h5Dataset) {
                H5DataSpace dataspace = this.gmfDataset.newDataSpace();
                for (int i = 0; i < this.endIndices.length; ++i) {
                    long start = this.startIndices[i];
                    long end = this.endIndices[i];
                    this.cachedBytes.put(start, dataspace.readElements(start, end - start));
                }
                dataspace.close();
            }
        }
    }

    private ByteBuffer readFrom(long start, long end) {
        this.populateCachedBytes();
        return this.cachedBytes.get(start);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        return String.format("GmfDataBySiteId(List, siteid=%d, size=%d)", this.siteId, this.size);
    }

    @Generated
    public long getSiteId() {
        return this.siteId;
    }
}

