/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.oq.events;

import java.nio.ByteBuffer;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.lookup.LookupTable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.hdf5.H5CompoundMember;
import nz.org.riskscape.hdf5.H5Dataset;
import nz.org.riskscape.hdf5.cursor.H5FixedSizeCursor;
import nz.org.riskscape.hdf5.types.H5CompoundType;

public class EventMetadataLookup
implements LookupTable {
    private static final Struct VALUE_STRUCT = Struct.of((String)"source_id", (Type)Types.TEXT, (String)"rup_id", (Type)Types.INTEGER, (String)"n_occ", (Type)Types.INTEGER, (String)"occurrence_rate", (Type)Types.FLOATING, (String)"event_rate", (Type)Types.FLOATING);
    private final Type keyType = Types.INTEGER;
    private final Type valueType = VALUE_STRUCT;
    private final H5FixedSizeCursor eventCursor;
    private final H5CompoundMember ruptureMember;
    private final H5FixedSizeCursor ruptureCursor;
    private final H5CompoundMember sourceIdMember;
    private final H5CompoundMember numberOccurencesMember;
    private final H5CompoundMember occurenceRateMember;
    private final Function<ByteBuffer, String> readSourceId;

    public EventMetadataLookup(H5Dataset eventDataset, H5Dataset ruptureDataset) {
        this.eventCursor = (H5FixedSizeCursor)eventDataset.openCursor();
        H5CompoundType eventType = (H5CompoundType)eventDataset.getDataType();
        this.ruptureMember = eventType.findMember("rup_id");
        this.ruptureCursor = (H5FixedSizeCursor)ruptureDataset.openCursor();
        H5CompoundType ruptureType = (H5CompoundType)ruptureDataset.getDataType();
        if (ruptureType.findIndex("source_id") > 0) {
            this.sourceIdMember = ruptureType.findMember("source_id");
            this.readSourceId = bb -> (String)this.ruptureCursor.peek(this.sourceIdMember);
        } else {
            this.sourceIdMember = ruptureType.findMember("srcidx");
            this.readSourceId = bb -> "srcidx=" + this.ruptureCursor.peek(this.sourceIdMember).toString();
        }
        this.numberOccurencesMember = ruptureType.findMember("n_occ");
        this.occurenceRateMember = ruptureType.findMember("occurrence_rate");
    }

    private long getRuptureId(long eventId) {
        this.eventCursor.setCurrentIndex(eventId);
        ByteBuffer bb = this.eventCursor.getByteBuffer();
        return ((Number)this.eventCursor.peek(this.ruptureMember)).longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(Object key) {
        long eventId = (Long)key;
        EventMetadataLookup eventMetadataLookup = this;
        synchronized (eventMetadataLookup) {
            long ruptureId = this.getRuptureId(eventId);
            this.ruptureCursor.setCurrentIndex(ruptureId);
            ByteBuffer bb = this.ruptureCursor.getByteBuffer();
            String sourceId = this.readSourceId.apply(bb);
            long numberOccurrences = ((Number)this.ruptureCursor.peek(this.numberOccurencesMember)).longValue();
            double occurrenceRate = ((Number)this.ruptureCursor.peek(this.occurenceRateMember)).doubleValue();
            double eventRate = occurrenceRate / (double)numberOccurrences;
            return Tuple.ofValues((Struct)VALUE_STRUCT, (Object[])new Object[]{sourceId, ruptureId, numberOccurrences, occurrenceRate, eventRate});
        }
    }

    @Generated
    public EventMetadataLookup(H5FixedSizeCursor eventCursor, H5CompoundMember ruptureMember, H5FixedSizeCursor ruptureCursor, H5CompoundMember sourceIdMember, H5CompoundMember numberOccurencesMember, H5CompoundMember occurenceRateMember, Function<ByteBuffer, String> readSourceId) {
        this.eventCursor = eventCursor;
        this.ruptureMember = ruptureMember;
        this.ruptureCursor = ruptureCursor;
        this.sourceIdMember = sourceIdMember;
        this.numberOccurencesMember = numberOccurencesMember;
        this.occurenceRateMember = occurenceRateMember;
        this.readSourceId = readSourceId;
    }

    @Generated
    public Type getKeyType() {
        return this.keyType;
    }

    @Generated
    public Type getValueType() {
        return this.valueType;
    }
}

