/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.oq;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.io.File;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.data.BaseBookmarkResolver;
import nz.org.riskscape.engine.data.BookmarkParameters;
import nz.org.riskscape.engine.data.coverage.NearestNeighbourCoverage;
import nz.org.riskscape.engine.function.ExpensiveResource;
import nz.org.riskscape.engine.geo.NearestNeighbourIndex;
import nz.org.riskscape.engine.lookup.LookupTable;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.hdf5.H5CompoundMember;
import nz.org.riskscape.hdf5.H5Dataset;
import nz.org.riskscape.hdf5.H5DatasetPath;
import nz.org.riskscape.hdf5.H5File;
import nz.org.riskscape.hdf5.relation.H5Relation;
import nz.org.riskscape.hdf5.types.H5CompoundType;
import nz.org.riskscape.oq.events.EventMetadataLookup;
import nz.org.riskscape.oq.gmf.GmfDataLookupBySite;
import nz.org.riskscape.oq.gmf.SitecolGmfDataIndex;
import nz.org.riskscape.oq.sitecol.SitecolRelation;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;

public class OpenQuakeResolver
extends BaseBookmarkResolver<Parameters> {
    private static final int CURSOR_PAGE_SIZE_MB = 4;
    private final Map<String, String> extensionsToFormats = ImmutableMap.of((Object)"hdf5", (Object)"openquake");

    public OpenQuakeResolver(Engine engine) {
        super(engine);
    }

    protected ResultOrProblems build(Parameters parameters) {
        switch (parameters.mode) {
            case COVERAGE_SITE_IDS: {
                return this.buildCoverageAllEvents(parameters);
            }
            case RELATION_SITE_IDS: {
                return this.buildRelationSiteIds(parameters);
            }
            case LOOKUP_GMV_BY_SITE: {
                return this.buildLookupGmvBySite(parameters);
            }
            case LOOKUP_EVENT_METADATA: {
                return this.buildLookupEventMetadata(parameters);
            }
        }
        throw new UnsupportedOperationException(parameters.mode.toString());
    }

    private ResultOrProblems<LookupTable> buildLookupEventMetadata(Parameters parameters) {
        H5Dataset eventsDataset = parameters.openEventsDataset();
        H5Dataset rupturesDataset = parameters.openRupturesDataset();
        return ResultOrProblems.of((Object)new EventMetadataLookup(eventsDataset, rupturesDataset));
    }

    private ResultOrProblems<LookupTable> buildLookupGmvBySite(Parameters parameters) {
        SitecolGmfDataIndex gmfDataIndex = new SitecolGmfDataIndex(parameters.openGmfIndicesDataset());
        H5Dataset gmfDataset = parameters.openGmfDataDataset();
        return ResultOrProblems.of((Object)new GmfDataLookupBySite(gmfDataIndex, gmfDataset));
    }

    private ResultOrProblems<Relation> buildRelationSiteIds(Parameters parameters) {
        return ResultOrProblems.of((Object)((Object)new SitecolRelation(parameters.openSitecolDataset(), parameters.sourceCrs, parameters.getRealizationContext().getProject().getSridSet())));
    }

    protected ResultOrProblems<NearestNeighbourCoverage> buildCoverageAllEvents(Parameters parameters) {
        if (parameters.maxSiteDistanceMetres <= 0.0) {
            return ResultOrProblems.failed((Problem[])new Problem[]{GeneralProblems.get().valueOutOfRange((Object)"max-site-distance-metres", (Comparable)Double.valueOf(parameters.maxSiteDistanceMetres), Range.greaterThan((Comparable)Double.valueOf(0.0)))});
        }
        Struct siteType = Struct.of((String)"point", (Type)Referenced.of((Type)Types.POINT, (CoordinateReferenceSystem)parameters.sourceCrs), (String)"sid", (Type)Types.INTEGER);
        CoordinateReferenceSystem crs = parameters.sourceCrs;
        GeometryFactory gm = parameters.getProject().getSridSet().getGeometryFactory(crs);
        H5Dataset siteDataset = parameters.openSitecolDataset();
        H5CompoundType siteDataType = (H5CompoundType)siteDataset.getDataType();
        H5CompoundMember lonMember = siteDataType.findMember("lon");
        H5CompoundMember latMember = siteDataType.findMember("lat");
        AtomicLong indexGenerator = new AtomicLong(0L);
        H5Relation siteRelation = new H5Relation(siteDataset, siteType, cursor -> {
            Number lon = (Number)cursor.peek(lonMember);
            Number lat = (Number)cursor.peek(latMember);
            return Tuple.ofValues((Struct)siteType, (Object[])new Object[]{gm.createPoint(new Coordinate((double)lat.floatValue(), (double)lon.floatValue())), indexGenerator.getAndIncrement()});
        }, 4);
        NearestNeighbourIndex index = NearestNeighbourIndex.metricMaxDistance((Struct.StructMember)((Struct.StructMember)siteType.getMember("point").get()), (SRIDSet)parameters.getProject().getSridSet(), (CoordinateReferenceSystem)crs, (double)parameters.maxSiteDistanceMetres);
        ExpensiveResource resource = new ExpensiveResource(parameters.getProject().getProblemSink(), "sitecol-" + parameters.getLocation().toString(), () -> {
            siteRelation.iterator().forEachRemaining(t -> index.insert(t));
            return index;
        });
        return ResultOrProblems.of((Object)new NearestNeighbourCoverage((Supplier)resource, (Type)siteType, crs, parameters.getProject().getSridSet()));
    }

    @Generated
    public Map<String, String> getExtensionsToFormats() {
        return this.extensionsToFormats;
    }

    public static class Parameters
    extends BookmarkParameters {
        @ParameterField
        public String sitecolDataset = "/sitecol";
        @ParameterField
        public String gmfIndicesDatasetPath = "/gmf_data/indices";
        @ParameterField
        public String gmfDataDatasetPath = "/gmf_data/data";
        @ParameterField
        public String eventsDatasetPath = "/events";
        @ParameterField
        public String rupturesDatasetPath = "/ruptures";
        @ParameterField
        public DatasetMode mode = DatasetMode.COVERAGE_SITE_IDS;
        @ParameterField(defaultValue="EPSG:4326")
        public CoordinateReferenceSystem sourceCrs;
        public H5File h5File;
        @ParameterField
        public double maxSiteDistanceMetres = 10000.0;

        public H5File getH5File() {
            if (this.h5File == null) {
                this.h5File = new H5File(((File)this.validatedFile.get()).toPath());
            }
            return this.h5File;
        }

        public Class<?> getDataType() {
            return this.mode.dataType;
        }

        public H5Dataset openSitecolDataset() {
            return this.getH5File().openDataset(H5DatasetPath.parse((String)this.sitecolDataset));
        }

        public H5Dataset openGmfIndicesDataset() {
            return this.getH5File().openDataset(H5DatasetPath.parse((String)this.gmfIndicesDatasetPath));
        }

        public H5Dataset openGmfDataDataset() {
            return this.getH5File().openDataset(H5DatasetPath.parse((String)this.gmfDataDatasetPath));
        }

        public H5Dataset openEventsDataset() {
            return this.getH5File().openDataset(H5DatasetPath.parse((String)this.eventsDatasetPath));
        }

        public H5Dataset openRupturesDataset() {
            return this.getH5File().openDataset(H5DatasetPath.parse((String)this.rupturesDatasetPath));
        }
    }

    public static enum DatasetMode {
        COVERAGE_SITE_IDS(TypedCoverage.class),
        RELATION_SITE_IDS(Relation.class),
        LOOKUP_GMV_BY_SITE(LookupTable.class),
        LOOKUP_EVENT_METADATA(LookupTable.class);

        private final Class<?> dataType;

        private DatasetMode(Class<?> dataType) {
            this.dataType = dataType;
        }

        public Class<?> getDataType() {
            return this.dataType;
        }
    }
}

