/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.i18n;

import com.google.common.base.CaseFormat;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import nz.org.riskscape.engine.i18n.Message;

@SupportedAnnotationTypes(value={"nz.org.riskscape.engine.i18n.Message"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class TranslationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Writer writer;
            if (!typeElement.getQualifiedName().toString().equals(Message.class.getCanonicalName())) continue;
            try {
                FileObject resource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "i18n", "problems.properties", new Element[0]);
                writer = resource.openWriter();
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Writing i18n to " + resource.getName());
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
                return true;
            }
            try {
                Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(typeElement);
                for (Element element : elements) {
                    if (!(element instanceof ExecutableElement)) continue;
                    Message message = element.getAnnotation(Message.class);
                    if (!(element.getEnclosingElement() instanceof TypeElement)) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Enclosing element is not a class or interface!", element);
                        continue;
                    }
                    TypeElement classElement = (TypeElement)element.getEnclosingElement();
                    String className = classElement.getQualifiedName().toString();
                    String methodName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, element.getSimpleName().toString());
                    String messageValue = message.value();
                    writer.write(className);
                    writer.write(".");
                    writer.write(methodName);
                    writer.write(" = \\\n  ");
                    writer.write(messageValue);
                    writer.write("\n\n");
                }
                writer.close();
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        }
        return true;
    }
}

