/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.ogr;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.data.BookmarkParameters;
import nz.org.riskscape.engine.data.relation.FeatureSourceBookmarkResolver;
import nz.org.riskscape.engine.data.relation.RelationBookmarkParams;
import nz.org.riskscape.ogr.OgrHelper;
import nz.org.riskscape.problem.Problem;
import org.geotools.data.ogr.OGRDataStore;

public class OgrResolver
extends FeatureSourceBookmarkResolver<OGRDataStore, OgrParams> {
    private final OgrHelper ogrHelper;

    public OgrResolver(Engine engine, OgrHelper helper) {
        super(engine);
        this.ogrHelper = helper;
    }

    protected Map<String, Serializable> createOgrConnectionParameters(OgrParams params) {
        if (!params.ogrSource.isPresent()) {
            Path ogr = this.getBookmarkedPath((BookmarkParameters)params);
            params.ogrSource = Optional.of(ogr.toFile().toString());
        }
        return ImmutableMap.of((Object)"DriverName", (Object)params.ogrDriver, (Object)"DatasourceName", (Object)((Serializable)((Object)params.ogrSource.get())));
    }

    protected OGRDataStore createDataStore(OgrParams params) throws MalformedURLException, IOException {
        OGRDataStore ds = (OGRDataStore)this.ogrHelper.getDataSourceFactory().orElseThrow(() -> new RiskscapeException("OGR not available on this system")).createDataStore(this.createOgrConnectionParameters(params));
        return ds;
    }

    protected void validateParameters(OgrParams params, BindingContext context) {
        if (!this.ogrHelper.isAvailable()) {
            params.problems.add(Problem.warning((String)"OGR does not appear to be installed on this system", (Object[])new Object[0]));
        } else if (!this.ogrHelper.getAvailableDrivers().contains(params.ogrDriver)) {
            params.problems.add(Problem.error((String)"ogr driver %s is not available on this system. Run 'ogrinfo --formats' to list available drivers", (Object[])new Object[]{params.ogrDriver}));
        }
    }

    public Set<String> getFormats() {
        return Sets.newHashSet((Object[])new String[]{"ogr"});
    }

    protected Map<String, String> getExtensionsToFormats() {
        return Collections.emptyMap();
    }

    public static class OgrParams
    extends RelationBookmarkParams {
        @ParameterField
        public String ogrDriver;
        @ParameterField
        public Optional<String> ogrSource = Optional.empty();
    }
}

