/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.ogr;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Map;
import java.util.Set;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.data.BookmarkParameters;
import nz.org.riskscape.ogr.OgrHelper;
import nz.org.riskscape.ogr.OgrResolver;
import nz.org.riskscape.problem.Problem;

public class GdbResolver
extends OgrResolver {
    private static final String OPEN_GDB_DRIVER_NAME = "OpenFileGDB";

    public GdbResolver(Engine engine, OgrHelper helper) {
        super(engine, helper);
    }

    @Override
    protected Map<String, String> getExtensionsToFormats() {
        return ImmutableMap.of((Object)"gdb/", (Object)"gdb", (Object)"gdb", (Object)"gdb");
    }

    @Override
    public Set<String> getFormats() {
        return Sets.newHashSet(this.getExtensionsToFormats().values());
    }

    protected void checkFile(OgrResolver.OgrParams params, File file) {
        super.checkFile((BookmarkParameters)params, file);
        if (file.exists() && !file.isDirectory()) {
            params.add(Problem.error((String)"'%s' is not a directory - set location to be your geodatabase directory", (Object[])new Object[]{file}));
        }
    }

    protected JavaParameterSet<OgrResolver.OgrParams> buildParameterSet() {
        OgrResolver.OgrParams ogrParams = new OgrResolver.OgrParams();
        ogrParams.ogrDriver = OPEN_GDB_DRIVER_NAME;
        return JavaParameterSet.fromBindingInstance(OgrResolver.OgrParams.class, (Object)((Object)ogrParams));
    }
}

