/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.csv;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvValidationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;

public class CSVFileState {
    private char separator = (char)44;
    private char quotechar = (char)34;
    private char escapechar = (char)92;
    private String lineSeparator = System.lineSeparator();
    private boolean quoteAllFields = false;
    static final Logger LOGGER = Logging.getLogger(CSVFileState.class);
    private final File file;
    private final String typeName;
    private CoordinateReferenceSystem crs;
    private final URI namespace;
    private final String dataInput;
    private volatile String[] headers = null;

    private static CoordinateReferenceSystem DEFAULT_CRS() throws FactoryException {
        return CRS.decode("EPSG:4326");
    }

    public CSVFileState(File file) {
        this(file, null, null);
    }

    public CSVFileState(File file, URI namespace) {
        this(file, namespace, null);
    }

    public CSVFileState(File file, URI namespace, String typeName) {
        this(file, namespace, typeName, null);
        File parent = file.getParentFile();
        String prjName = FilenameUtils.getBaseName((String)file.getName()) + ".prj";
        File prjFile = new File(parent, prjName);
        if (prjFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(prjFile));){
                String line;
                StringBuffer prj = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    prj.append(line);
                }
                this.setCrs(CRS.parseWKT(prj.toString()));
            }
            catch (IOException | FactoryException e) {
                LOGGER.log(Level.SEVERE, "", e);
            }
        }
    }

    public CSVFileState(File file, URI namespace, String typeName, CoordinateReferenceSystem crs) {
        this.file = file;
        this.typeName = typeName;
        this.setCrs(crs);
        this.namespace = namespace;
        this.dataInput = null;
    }

    public CSVFileState(String dataInput, String typeName) {
        this.dataInput = dataInput;
        this.typeName = typeName;
        this.setCrs(null);
        this.namespace = null;
        this.file = null;
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public File getFile() {
        return this.file;
    }

    public String getTypeName() {
        return this.typeName != null ? this.typeName : FilenameUtils.getBaseName((String)this.file.getPath());
    }

    public CoordinateReferenceSystem getCrs() {
        if (this.crs != null) {
            return this.crs;
        }
        try {
            return CSVFileState.DEFAULT_CRS();
        }
        catch (FactoryException e) {
            return null;
        }
    }

    public void setCrs(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSVReader openCSVReader() throws IOException, CsvValidationException {
        Reader reader = null;
        if (this.file != null) {
            LOGGER.fine("opening file: " + this.file + " exists? " + this.file.exists());
            reader = new BufferedReader(new FileReader(this.file));
        } else {
            reader = new StringReader(this.dataInput);
        }
        CSVParser parser = new CSVParserBuilder().withSeparator(this.separator).withEscapeChar(this.escapechar).withQuoteChar(this.quotechar).withIgnoreLeadingWhiteSpace(true).build();
        CSVReader csvReader = new CSVReaderBuilder(reader).withCSVParser((ICSVParser)parser).build();
        String[] tnames = csvReader.readNext();
        if (tnames == null) {
            reader.close();
            throw new IOException("Error reading csv headers");
        }
        if (this.headers == null) {
            CSVFileState cSVFileState = this;
            synchronized (cSVFileState) {
                for (int i = 0; i < tnames.length; ++i) {
                    tnames[i] = tnames[i].trim();
                }
                this.headers = tnames;
            }
        }
        return csvReader;
    }

    public String[] getCSVHeaders() {
        if (this.headers == null) {
            throw new RuntimeException("Attempting to access unopened CSV Reader");
        }
        return this.headers;
    }

    public char getQuotechar() {
        return this.quotechar;
    }

    public void setQuotechar(char quotechar) {
        this.quotechar = quotechar;
    }

    public void setEscapechar(char escapechar2) {
        this.escapechar = escapechar2;
    }

    public char getEscapechar() {
        return this.escapechar;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public boolean isQuoteAllFields() {
        return this.quoteAllFields;
    }

    public void setQuoteAllFields(boolean quoteAllFields) {
        this.quoteAllFields = quoteAllFields;
    }
}

