/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.csv;

import java.io.IOException;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.data.csv.CSVDataStore;
import org.geotools.data.csv.CSVFeatureSource;
import org.geotools.data.csv.CSVFeatureWriter;
import org.geotools.data.csv.CSVFileState;
import org.geotools.data.csv.parse.CSVStrategy;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class CSVFeatureStore
extends ContentFeatureStore {
    private CSVStrategy csvStrategy;
    private CSVFileState csvFileState;
    CSVFeatureSource delegate;

    public CSVFeatureStore(CSVStrategy csvStrategy, CSVFileState csvFileState, ContentEntry entry, Query query) {
        super(entry, query);
        this.delegate = new CSVFeatureSource(this.entry, this.query){

            @Override
            public void setTransaction(Transaction transaction) {
                super.setTransaction(transaction);
                CSVFeatureStore.this.setTransaction(transaction);
            }
        };
        this.csvStrategy = csvStrategy;
        this.csvFileState = csvFileState;
    }

    @Override
    protected FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(Query query, int flags) throws IOException {
        return new CSVFeatureWriter(this.csvFileState, this.csvStrategy, query);
    }

    @Override
    public void setTransaction(Transaction transaction) {
        super.setTransaction(transaction);
        if (this.delegate.getTransaction() != transaction) {
            this.delegate.setTransaction(transaction);
        }
    }

    @Override
    protected SimpleFeatureType buildFeatureType() throws IOException {
        return this.delegate.buildFeatureType();
    }

    @Override
    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        return this.delegate.getBoundsInternal(query);
    }

    @Override
    protected int getCountInternal(Query query) throws IOException {
        return this.delegate.getCountInternal(query);
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return this.delegate.getReaderInternal(query);
    }

    @Override
    public CSVDataStore getDataStore() {
        return this.delegate.getDataStore();
    }

    @Override
    public ContentEntry getEntry() {
        return this.delegate.getEntry();
    }

    @Override
    public Transaction getTransaction() {
        return this.delegate.getTransaction();
    }

    @Override
    public ContentState getState() {
        return this.delegate.getState();
    }

    @Override
    public ResourceInfo getInfo() {
        return this.delegate.getInfo();
    }

    @Override
    public Name getName() {
        return this.delegate.getName();
    }

    @Override
    public QueryCapabilities getQueryCapabilities() {
        return this.delegate.getQueryCapabilities();
    }
}

