/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.csv;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.FileDataStore;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.data.csv.CSVFeatureSource;
import org.geotools.data.csv.CSVFeatureStore;
import org.geotools.data.csv.CSVFileState;
import org.geotools.data.csv.parse.CSVStrategy;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;

public class CSVDataStore
extends ContentDataStore
implements FileDataStore {
    private final CSVStrategy csvStrategy;
    private final CSVFileState csvFileState;

    public CSVDataStore(CSVFileState csvFileState, CSVStrategy csvStrategy) {
        this.csvFileState = csvFileState;
        this.csvStrategy = csvStrategy;
    }

    public Name getTypeName() {
        if (this.namespaceURI != null) {
            return new NameImpl(this.namespaceURI, this.csvFileState.getTypeName());
        }
        return new NameImpl(this.csvFileState.getTypeName());
    }

    @Override
    protected List<Name> createTypeNames() throws IOException {
        return Collections.singletonList(this.getTypeName());
    }

    @Override
    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        if (this.csvFileState.getFile() != null && this.csvFileState.getFile().canWrite()) {
            return new CSVFeatureStore(this.csvStrategy, this.csvFileState, entry, Query.ALL);
        }
        return new CSVFeatureSource(entry, Query.ALL);
    }

    @Override
    public SimpleFeatureType getSchema() throws IOException {
        return this.csvStrategy.getFeatureType();
    }

    @Override
    public void updateSchema(SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SimpleFeatureSource getFeatureSource() throws IOException {
        return super.getFeatureSource(this.getTypeName());
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader() throws IOException {
        return new CSVFeatureSource(this).getReader();
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(Filter filter, Transaction transaction) throws IOException {
        return super.getFeatureWriter(this.csvFileState.getTypeName(), filter, transaction);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(Transaction transaction) throws IOException {
        return super.getFeatureWriter(this.csvFileState.getTypeName(), transaction);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(Transaction transaction) throws IOException {
        return super.getFeatureWriterAppend(this.csvFileState.getTypeName(), transaction);
    }

    public CSVStrategy getCSVStrategy() {
        return this.csvStrategy;
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        this.csvStrategy.createSchema(featureType);
        this.csvFileState.setCrs(featureType.getCoordinateReferenceSystem());
    }
}

