/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.referencing.FactoryException;
import org.geotools.data.wfs.internal.GetParser;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.data.wfs.internal.WFSStrategy;
import org.geotools.gml.stream.XmlStreamGeometryReader;
import org.geotools.gml3.GML;
import org.geotools.util.Converters;
import org.geotools.wfs.WFS;
import org.locationtech.jts.geom.GeometryFactory;

public abstract class XmlFeatureParser<FT extends FeatureType, F extends Feature>
implements GetParser<F> {
    protected FT targetType;
    private InputStream inputStream;
    protected XMLStreamReader parser;
    private XmlStreamGeometryReader geometryReader;
    final String featureNamespace;
    final String featureName;
    private int numberOfFeatures = -1;
    private static final Logger LOGGER = Loggers.RESPONSES;

    public XmlFeatureParser(InputStream getFeatureResponseStream, FT targetType, QName featureDescriptorName, WFSStrategy strategy) throws IOException {
        this.inputStream = getFeatureResponseStream;
        this.featureNamespace = featureDescriptorName.getNamespaceURI();
        this.featureName = featureDescriptorName.getLocalPart();
        this.targetType = targetType;
        try {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.supportDTD", false);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            this.parser = factory.createXMLStreamReader(this.inputStream, "UTF-8");
            this.geometryReader = new XmlStreamGeometryReader(this.parser, new GeometryFactory());
            while (this.parser.hasNext() && 1 != this.parser.next()) {
            }
            String namespace = strategy == null ? "http://www.opengis.net/wfs" : strategy.getWfsConfiguration().getNamespaceURI();
            this.parser.require(1, namespace, WFS.FeatureCollection.getLocalPart());
            String nof = this.parser.getAttributeValue(null, "numberOfFeatures");
            if (nof != null) {
                try {
                    this.numberOfFeatures = Integer.valueOf(nof);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warning("Can't parse numberOfFeatures out of " + nof);
                }
            }
        }
        catch (XMLStreamException e) {
            getFeatureResponseStream.close();
            this.inputStream = null;
            throw new DataSourceException((Throwable)e);
        }
    }

    @Override
    public void setGeometryFactory(GeometryFactory geometryFactory) {
        if (null != geometryFactory) {
            this.geometryReader.setGeometryFactory(geometryFactory);
        }
    }

    public FT getFeatureType() {
        return this.targetType;
    }

    @Override
    public int getNumberOfFeatures() {
        return this.numberOfFeatures;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            try {
                this.parser.close();
                this.parser = null;
                this.inputStream.close();
                this.inputStream = null;
            }
            catch (XMLStreamException e) {
                throw new DataSourceException((Throwable)e);
            }
        }
    }

    protected Object parseAttributeValue(AttributeDescriptor attribute) throws XMLStreamException, IOException {
        Object parsedValue;
        AttributeType type = attribute.getType();
        if (type instanceof GeometryType) {
            this.parser.nextTag();
            try {
                parsedValue = this.geometryReader.readGeometry();
            }
            catch (FactoryException e) {
                throw new DataSourceException((Throwable)e);
            }
        } else {
            String rawTextValue = this.parser.getElementText();
            Class binding = type.getBinding();
            parsedValue = Converters.convert((Object)rawTextValue, (Class)binding);
        }
        return parsedValue;
    }

    protected String seekFeature() throws IOException, XMLStreamException {
        while (true) {
            int tagType;
            if ((tagType = this.parser.next()) == 8) {
                this.close();
                return null;
            }
            if (1 != tagType) continue;
            String namespace = this.parser.getNamespaceURI();
            String name = this.parser.getLocalName();
            if (this.featureNamespace.equals(namespace) && this.featureName.equals(name)) break;
        }
        String featureId = this.parser.getAttributeValue(GML.id.getNamespaceURI(), GML.id.getLocalPart());
        if (featureId == null) {
            featureId = this.parser.getAttributeValue(null, "fid");
        }
        if (featureId == null) {
            featureId = this.parser.getAttributeValue(null, "id");
        }
        return featureId;
    }
}

