/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.awt.RenderingHints;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.wfs.impl.WFSDataAccessFactory;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.xml.sax.EntityResolver;

public class WFSConfig {
    private static final Logger LOGGER = Logging.getLogger(WFSConfig.class);
    protected String user;
    protected String pass;
    protected int timeoutMillis;
    protected PreferredHttpMethod preferredMethod = PreferredHttpMethod.AUTO;
    protected int buffer;
    protected boolean tryGZIP;
    protected boolean lenient;
    protected Integer maxFeatures;
    protected Charset defaultEncoding;
    protected String wfsStrategy;
    protected Integer filterCompliance;
    protected String namespaceOverride;
    protected String outputformatOverride;
    protected boolean useDefaultSrs;
    protected String axisOrder;
    protected String axisOrderFilter;
    protected boolean gmlCompatibleTypenames;
    protected boolean useHttpConnectionPooling;
    protected int maxConnectionPoolSize;
    protected EntityResolver entityResolver;
    protected Map<String, String> additionalHeaders;
    private static final String NAME_SEPARATOR = ":";
    private static final String NAME_SEPARATOR_GML_COMPATIBLE = "_";

    public WFSConfig() {
        this.timeoutMillis = (Integer)WFSDataAccessFactory.TIMEOUT.getDefaultValue();
        this.buffer = (Integer)WFSDataAccessFactory.BUFFER_SIZE.getDefaultValue();
        this.tryGZIP = (Boolean)WFSDataAccessFactory.TRY_GZIP.getDefaultValue();
        this.lenient = (Boolean)WFSDataAccessFactory.LENIENT.getDefaultValue();
        String encoding = (String)WFSDataAccessFactory.ENCODING.getDefaultValue();
        this.defaultEncoding = Charset.forName(encoding);
        this.maxFeatures = (Integer)WFSDataAccessFactory.MAXFEATURES.getDefaultValue();
        this.wfsStrategy = (String)WFSDataAccessFactory.WFS_STRATEGY.getDefaultValue();
        this.filterCompliance = (Integer)WFSDataAccessFactory.FILTER_COMPLIANCE.getDefaultValue();
        this.namespaceOverride = (String)WFSDataAccessFactory.NAMESPACE.getDefaultValue();
        this.gmlCompatibleTypenames = (Boolean)WFSDataAccessFactory.GML_COMPATIBLE_TYPENAMES.getDefaultValue();
        this.entityResolver = (EntityResolver)WFSDataAccessFactory.ENTITY_RESOLVER.getDefaultValue();
        this.useHttpConnectionPooling = (Boolean)WFSDataAccessFactory.USE_HTTP_CONNECTION_POOLING.getDefaultValue();
        this.maxConnectionPoolSize = (Integer)WFSDataAccessFactory.MAX_CONNECTION_POOL_SIZE.getDefaultValue();
    }

    public static WFSConfig fromParams(Map<?, ?> params) throws IOException {
        WFSConfig config = new WFSConfig();
        Boolean preferPost = WFSDataAccessFactory.PROTOCOL.lookUp(params);
        config.preferredMethod = preferPost == null ? PreferredHttpMethod.AUTO : (preferPost != false ? PreferredHttpMethod.HTTP_POST : PreferredHttpMethod.HTTP_GET);
        config.user = WFSDataAccessFactory.USERNAME.lookUp(params);
        config.pass = WFSDataAccessFactory.PASSWORD.lookUp(params);
        config.timeoutMillis = WFSDataAccessFactory.TIMEOUT.lookUp(params);
        config.buffer = WFSDataAccessFactory.BUFFER_SIZE.lookUp(params);
        config.tryGZIP = WFSDataAccessFactory.TRY_GZIP.lookUp(params);
        config.lenient = WFSDataAccessFactory.LENIENT.lookUp(params);
        String encoding = WFSDataAccessFactory.ENCODING.lookUp(params);
        config.defaultEncoding = Charset.forName(encoding);
        config.maxFeatures = WFSDataAccessFactory.MAXFEATURES.lookUp(params);
        config.wfsStrategy = WFSDataAccessFactory.WFS_STRATEGY.lookUp(params);
        config.filterCompliance = WFSDataAccessFactory.FILTER_COMPLIANCE.lookUp(params);
        config.namespaceOverride = WFSDataAccessFactory.NAMESPACE.lookUp(params);
        config.outputformatOverride = WFSDataAccessFactory.OUTPUTFORMAT.lookUp(params);
        config.axisOrder = WFSDataAccessFactory.AXIS_ORDER.lookUp(params);
        config.axisOrderFilter = WFSDataAccessFactory.AXIS_ORDER_FILTER.lookUp(params) == null ? WFSDataAccessFactory.AXIS_ORDER.lookUp(params) : WFSDataAccessFactory.AXIS_ORDER_FILTER.lookUp(params);
        config.gmlCompatibleTypenames = WFSDataAccessFactory.GML_COMPATIBLE_TYPENAMES.lookUp(params) == null ? (Boolean)WFSDataAccessFactory.GML_COMPATIBLE_TYPENAMES.getDefaultValue() : WFSDataAccessFactory.GML_COMPATIBLE_TYPENAMES.lookUp(params);
        config.entityResolver = WFSDataAccessFactory.ENTITY_RESOLVER.lookUp(params);
        config.useHttpConnectionPooling = WFSDataAccessFactory.USE_HTTP_CONNECTION_POOLING.lookUp(params);
        config.maxConnectionPoolSize = WFSDataAccessFactory.MAX_CONNECTION_POOL_SIZE.lookUp(params);
        config.additionalHeaders = WFSConfig.extractAdditionalHeaders(params);
        return config;
    }

    private static Map<String, String> extractAdditionalHeaders(Map<?, ?> params) throws IOException {
        Map headersRaw = WFSDataAccessFactory.ADDITIONAL_HEADERS.lookUp(params);
        if (headersRaw != null) {
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            headersRaw.forEach((key, value) -> {
                if (key instanceof String && value instanceof String) {
                    headers.put(key.toString(), value.toString());
                } else {
                    LOGGER.warning("Ignoring additional header. Not string-typed. Key: " + key + ", value: " + value + ". Key type: " + (key == null ? null : key.getClass().getName()) + ", value type: " + (value == null ? null : value.getClass().getName()));
                }
            });
            return headers;
        }
        return null;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.pass;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public PreferredHttpMethod getPreferredMethod() {
        return this.preferredMethod;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public boolean isTryGZIP() {
        return this.tryGZIP;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public Integer getMaxFeatures() {
        return this.maxFeatures;
    }

    public Charset getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getWfsStrategy() {
        return this.wfsStrategy;
    }

    public Integer getFilterCompliance() {
        return this.filterCompliance;
    }

    public String getNamespaceOverride() {
        return this.namespaceOverride;
    }

    public String getOutputformatOverride() {
        return this.outputformatOverride;
    }

    public boolean isUseDefaultSrs() {
        return this.useDefaultSrs;
    }

    public String getAxisOrder() {
        return this.axisOrder;
    }

    public String getAxisOrderFilter() {
        return this.axisOrderFilter;
    }

    public boolean isGmlCompatibleTypenames() {
        return this.gmlCompatibleTypenames;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public boolean isUseHttpConnectionPooling() {
        return this.useHttpConnectionPooling;
    }

    public int getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    public Map<String, String> getAdditionalHeaders() {
        if (this.additionalHeaders == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.additionalHeaders);
    }

    public static boolean invertAxisNeeded(String axisOrder, CoordinateReferenceSystem crs) {
        CRS.AxisOrder requestedAxis = CRS.getAxisOrder((CoordinateReferenceSystem)crs);
        if (requestedAxis == CRS.AxisOrder.INAPPLICABLE) {
            boolean forcedLonLat = Boolean.getBoolean("org.geotools.referencing.forceXY") || Boolean.TRUE.equals(Hints.getSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER));
            requestedAxis = forcedLonLat ? CRS.AxisOrder.EAST_NORTH : CRS.AxisOrder.NORTH_EAST;
        }
        if ("North / East".equals(axisOrder)) {
            return requestedAxis.equals((Object)CRS.AxisOrder.EAST_NORTH);
        }
        if ("East / North".equals(axisOrder)) {
            return requestedAxis.equals((Object)CRS.AxisOrder.NORTH_EAST);
        }
        return false;
    }

    public String localTypeName(QName remoteTypeName) {
        Object localTypeName = remoteTypeName.getLocalPart();
        if (!"".equals(remoteTypeName.getPrefix())) {
            localTypeName = remoteTypeName.getPrefix() + (this.gmlCompatibleTypenames ? NAME_SEPARATOR_GML_COMPATIBLE : NAME_SEPARATOR) + (String)localTypeName;
        }
        return localTypeName;
    }

    public static enum PreferredHttpMethod {
        AUTO,
        HTTP_GET,
        HTTP_POST;

    }
}

